/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.event.RenderEventHandler;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.mixin.item.IMixinContainerComponent;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.game.IEntityOwnedInventory;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_10256;
import net.minecraft.class_10799;
import net.minecraft.class_11573;
import net.minecraft.class_11586;
import net.minecraft.class_11597;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1694;
import net.minecraft.class_1700;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2260;
import net.minecraft.class_2281;
import net.minecraft.class_2315;
import net.minecraft.class_2336;
import net.minecraft.class_2363;
import net.minecraft.class_2371;
import net.minecraft.class_2377;
import net.minecraft.class_2387;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2589;
import net.minecraft.class_2591;
import net.minecraft.class_2601;
import net.minecraft.class_2609;
import net.minecraft.class_2614;
import net.minecraft.class_2627;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3708;
import net.minecraft.class_3715;
import net.minecraft.class_4836;
import net.minecraft.class_5537;
import net.minecraft.class_7714;
import net.minecraft.class_7716;
import net.minecraft.class_8168;
import net.minecraft.class_8886;
import net.minecraft.class_8887;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.joml.Matrix3x2fStack;

public class InventoryOverlay {
    private static final AnsiLogger LOGGER = new AnsiLogger(InventoryOverlay.class);
    public static final class_2960 TEXTURE_BREWING_STAND = class_2960.method_60656((String)"textures/gui/container/brewing_stand.png");
    public static final class_2960 TEXTURE_CRAFTER = class_2960.method_60656((String)"textures/gui/container/crafter.png");
    public static final class_2960 TEXTURE_DISPENSER = class_2960.method_60656((String)"textures/gui/container/dispenser.png");
    public static final class_2960 TEXTURE_DOUBLE_CHEST = class_2960.method_60656((String)"textures/gui/container/generic_54.png");
    public static final class_2960 TEXTURE_FURNACE = class_2960.method_60656((String)"textures/gui/container/furnace.png");
    public static final class_2960 TEXTURE_HOPPER = class_2960.method_60656((String)"textures/gui/container/hopper.png");
    public static final class_2960 TEXTURE_PLAYER_INV = class_2960.method_60656((String)"textures/gui/container/inventory.png");
    public static final class_2960 TEXTURE_SINGLE_CHEST = class_2960.method_60656((String)"textures/gui/container/shulker_box.png");
    public static final class_2960 TEXTURE_EMPTY_SHIELD = class_2960.method_60656((String)"container/slot/shield");
    public static final class_2960 TEXTURE_LOCKED_SLOT = class_2960.method_60656((String)"container/crafter/disabled_slot");
    public static final class_2960 TEXTURE_EMPTY_HORSE_ARMOR = class_2960.method_60656((String)"container/slot/horse_armor");
    public static final class_2960 TEXTURE_EMPTY_LLAMA_ARMOR = class_2960.method_60656((String)"container/slot/llama_armor");
    public static final class_2960 TEXTURE_EMPTY_SADDLE = class_2960.method_60656((String)"container/slot/saddle");
    public static final class_2960 TEXTURE_EMPTY_BREWER_FUEL = class_2960.method_60656((String)"container/slot/brewing_fuel");
    public static final class_2960 TEXTURE_EMPTY_POTION = class_2960.method_60656((String)"container/slot/potion");
    public static final class_2960 TEXTURE_EMPTY_SLOT_AMETHYST = class_2960.method_60656((String)"container/slot/amethyst_shard");
    public static final class_2960 TEXTURE_EMPTY_SLOT_AXE = class_2960.method_60656((String)"container/slot/axe");
    public static final class_2960 TEXTURE_EMPTY_SLOT_BANNER = class_2960.method_60656((String)"container/slot/banner");
    public static final class_2960 TEXTURE_EMPTY_SLOT_PATTERN = class_2960.method_60656((String)"container/slot/banner_pattern");
    public static final class_2960 TEXTURE_EMPTY_SLOT_DIAMOND = class_2960.method_60656((String)"container/slot/diamond");
    public static final class_2960 TEXTURE_EMPTY_SLOT_DYE = class_2960.method_60656((String)"container/slot/dye");
    public static final class_2960 TEXTURE_EMPTY_SLOT_EMERALD = class_2960.method_60656((String)"container/slot/emerald");
    public static final class_2960 TEXTURE_EMPTY_SLOT_HOE = class_2960.method_60656((String)"container/slot/hoe");
    public static final class_2960 TEXTURE_EMPTY_SLOT_INGOT = class_2960.method_60656((String)"container/slot/ingot");
    public static final class_2960 TEXTURE_EMPTY_SLOT_LAPIS = class_2960.method_60656((String)"container/slot/lapis_lazuli");
    public static final class_2960 TEXTURE_EMPTY_SLOT_PICKAXE = class_2960.method_60656((String)"container/slot/pickaxe");
    public static final class_2960 TEXTURE_EMPTY_SLOT_QUARTZ = class_2960.method_60656((String)"container/slot/quartz");
    public static final class_2960 TEXTURE_EMPTY_SLOT_REDSTONE = class_2960.method_60656((String)"container/slot/redstone_dust");
    public static final class_2960 TEXTURE_EMPTY_SLOT_SHOVEL = class_2960.method_60656((String)"container/slot/shovel");
    public static final class_2960 TEXTURE_EMPTY_SLOT_ARMOR_TRIM = class_2960.method_60656((String)"container/slot/smithing_template_armor_trim");
    public static final class_2960 TEXTURE_EMPTY_SLOT_UPGRADE = class_2960.method_60656((String)"container/slot/smithing_template_netherite_upgrade");
    public static final class_2960 TEXTURE_EMPTY_SLOT_SWORD = class_2960.method_60656((String)"container/slot/sword");
    public static final class_2960 TEXTURE_EMPTY_SLOT = class_2960.method_60656((String)"container/slot");
    public static final class_2960 TEXTURE_HIGHLIGHT_BACK = class_2960.method_60656((String)"container/slot_highlight_back");
    public static final class_2960 TEXTURE_HIGHLIGHT_FRONT = class_2960.method_60656((String)"container/slot_highlight_front");
    private static final class_1304[] VALID_EQUIPMENT_SLOTS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    public static final InventoryProperties INV_PROPS_TEMP = new InventoryProperties();
    private static final class_2960[] EMPTY_SLOT_TEXTURES = new class_2960[]{class_2960.method_60656((String)"container/slot/boots"), class_2960.method_60656((String)"container/slot/leggings"), class_2960.method_60656((String)"container/slot/chestplate"), class_2960.method_60656((String)"container/slot/helmet")};
    private static class_1799 hoveredStack = null;

    public static void renderInventoryBackground(class_332 context, InventoryRenderType type, int x, int y, int slotsPerRow, int totalSlots, class_310 mc) {
        InventoryOverlay.renderInventoryBackground(context, type, x, y, slotsPerRow, totalSlots, -1, mc);
    }

    public static void renderInventoryBackground(class_332 context, InventoryRenderType type, int x, int y, int slotsPerRow, int totalSlots, int color, class_310 mc) {
        if (type == InventoryRenderType.FURNACE) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_FURNACE);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 4, 64, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 4, y, 84, 0, 92, 4, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 64, 0, 162, 92, 4, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 92, y + 4, 172, 102, 4, 64, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 4, y + 4, 52, 13, 88, 60, color);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_BREWING_STAND);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 4, 68, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 4, y, 63, 0, 113, 4, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 68, 0, 162, 113, 4, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 113, y + 4, 172, 98, 4, 68, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 4, y + 4, 13, 13, 109, 64, color);
        } else if (type == InventoryRenderType.CRAFTER) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DISPENSER);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 115, 0, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 61, 0, 159, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 61, y + 7, 169, 105, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 61, 16, 54, 54, color);
        } else if (type == InventoryRenderType.DISPENSER) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DISPENSER);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 115, 0, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 61, 0, 159, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 61, y + 7, 169, 105, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 61, 16, 54, 54, color);
        } else if (type == InventoryRenderType.HOPPER) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_HOPPER);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 25, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 79, 0, 97, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 25, 0, 126, 97, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 97, y + 7, 169, 108, 7, 25, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 43, 19, 90, 18, color);
        } else if (type == InventoryRenderType.VILLAGER) {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DOUBLE_CHEST);
            if (gpuTextureView == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 79, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 133, 0, 43, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 79, 0, 215, 43, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 43, y + 7, 169, 143, 7, 79, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 7, 17, 36, 72, color);
        } else if (type == InventoryRenderType.FIXED_27) {
            InventoryOverlay.renderInventoryBackground27(x, y, color, mc, context);
        } else if (type == InventoryRenderType.FIXED_54) {
            InventoryOverlay.renderInventoryBackground54(x, y, color, mc, context);
        } else {
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DOUBLE_CHEST);
            if (gpuTextureView == null) {
                return;
            }
            int rows = (int)Math.ceil((double)totalSlots / (double)slotsPerRow);
            int bgw = Math.min(totalSlots, slotsPerRow) * 18 + 7;
            int bgh = rows * 18 + 7;
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, bgh, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 176 - bgw, 0, bgw, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + bgh, 0, 215, bgw, 7, color);
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + bgw, y + 7, 169, 222 - bgh, 7, bgh, color);
            for (int row = 0; row < rows; ++row) {
                int rowLen = class_3532.method_15340((int)(totalSlots - row * slotsPerRow), (int)1, (int)slotsPerRow);
                RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + row * 18 + 7, 7, 17, rowLen * 18, 18, color);
                if (rows <= 1 || rowLen >= slotsPerRow) continue;
                RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + rowLen * 18 + 7, y + row * 18 + 7, 7, 3, (slotsPerRow - rowLen) * 18, 9, color);
                RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + rowLen * 18 + 7, y + row * 18 + 16, 7, 3, (slotsPerRow - rowLen) * 18, 9, color);
            }
        }
    }

    public static void renderInventoryBackground27(int x, int y, int color, class_310 mc, class_332 context) {
        GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_SINGLE_CHEST);
        if (gpuTextureView == null) {
            return;
        }
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 61, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 7, 0, 169, 7, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 61, 0, 159, 169, 7, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 169, y + 7, 169, 105, 7, 61, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 7, 17, 162, 54, color);
    }

    public static void renderInventoryBackground54(int x, int y, int color, class_310 mc, class_332 context) {
        GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DOUBLE_CHEST);
        if (gpuTextureView == null) {
            return;
        }
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 7, 115, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y, 7, 0, 169, 7, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 115, 0, 215, 169, 7, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 169, y + 7, 169, 107, 7, 115, color);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 7, y + 7, 7, 17, 162, 108, color);
    }

    public static void renderInventoryBackgroundSlots(class_332 drawContext, InventoryRenderType type, class_1263 inv, int x, int y) {
        if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.renderBrewerBackgroundSlots(drawContext, inv, x, y);
        } else if (type == InventoryRenderType.HORSE) {
            InventoryOverlay.renderHorseArmorBackgroundSlots(drawContext, inv, x, y);
        } else if (type == InventoryRenderType.LLAMA) {
            InventoryOverlay.renderLlamaArmorBackgroundSlots(drawContext, inv, x, y);
        } else if (type == InventoryRenderType.WOLF || type == InventoryRenderType.HAPPY_GHAST || type == InventoryRenderType.COPPER_GOLEM) {
            InventoryOverlay.renderWolfArmorBackgroundSlots(drawContext, inv, x, y);
        }
    }

    public static void renderBrewerBackgroundSlots(class_332 drawContext, class_1263 inv, int x, int y) {
        InventoryOverlay.renderBrewerBackgroundSlots(drawContext, inv, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderBrewerBackgroundSlots(class_332 drawContext, class_1263 inv, int x, int y, float scale, double mouseX, double mouseY) {
        if (inv.method_5438(0).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_POTION, x + 47, y + 42, scale, mouseX, mouseY);
        }
        if (inv.method_5438(1).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_POTION, x + 70, y + 49, scale, mouseX, mouseY);
        }
        if (inv.method_5438(2).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_POTION, x + 93, y + 42, scale, mouseX, mouseY);
        }
        if (inv.method_5438(4).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_BREWER_FUEL, x + 8, y + 8, scale, mouseX, mouseY);
        }
    }

    public static void renderHorseArmorBackgroundSlots(class_332 drawContext, class_1263 inv, int x, int y) {
        InventoryOverlay.renderHorseArmorBackgroundSlots(drawContext, inv, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderHorseArmorBackgroundSlots(class_332 drawContext, class_1263 inv, int x, int y, float scale, double mouseX, double mouseY) {
        if (inv.method_5438(0).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_HORSE_ARMOR, x, y, scale, mouseX, mouseY);
        }
        if (inv.method_5438(1).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_SADDLE, x, y + 18, scale, mouseX, mouseY);
        }
    }

    public static void renderLlamaArmorBackgroundSlots(class_332 drawContext, class_1263 inv, int x, int y) {
        InventoryOverlay.renderLlamaArmorBackgroundSlots(drawContext, inv, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderLlamaArmorBackgroundSlots(class_332 drawContext, class_1263 inv, int x, int y, float scale, double mouseX, double mouseY) {
        if (inv.method_5438(0).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_LLAMA_ARMOR, x, y, scale, mouseX, mouseY);
        }
    }

    public static void renderWolfArmorBackgroundSlots(class_332 drawContext, class_1263 inv, int x, int y) {
        InventoryOverlay.renderWolfArmorBackgroundSlots(drawContext, inv, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderWolfArmorBackgroundSlots(class_332 drawContext, class_1263 inv, int x, int y, float scale, double mouseX, double mouseY) {
        if (inv.method_5438(0).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(drawContext, TEXTURE_EMPTY_HORSE_ARMOR, x, y, scale, mouseX, mouseY);
        }
    }

    public static void renderEquipmentOverlayBackground(class_332 context, int x, int y, class_1309 entity) {
        GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(TEXTURE_DISPENSER);
        if (gpuTextureView == null) {
            return;
        }
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y, 0, 0, 50, 83);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 50, y, 173, 0, 3, 83);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x, y + 83, 0, 163, 50, 3);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 50, y + 83, 173, 163, 3, 3);
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + xOff, y + yOff, 61, 16, 18, 18);
            ++i;
            yOff += 18;
        }
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 28, y + 36 + 7, 61, 16, 18, 18);
        RenderUtils.drawTexturedRectBatched(context, gpuTextureView, x + 28, y + 54 + 7, 61, 16, 18, 18);
        if (entity.method_6118(class_1304.field_6171).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(context, TEXTURE_EMPTY_SHIELD, x + 28 + 1, y + 54 + 7 + 1);
        }
        i = 0;
        xOff = 7;
        yOff = 7;
        while (i < 4) {
            class_1304 eqSlot = VALID_EQUIPMENT_SLOTS[i];
            if (entity.method_6118(eqSlot).method_7960()) {
                class_2960 texture = EMPTY_SLOT_TEXTURES[eqSlot.method_5927()];
                InventoryOverlay.renderBackgroundSlotAt(context, texture, x + xOff + 1, y + yOff + 1);
            }
            ++i;
            yOff += 18;
        }
    }

    public static InventoryRenderType getInventoryType(@Nullable class_1263 inv) {
        if (inv == null) {
            return InventoryRenderType.GENERIC;
        }
        if (inv instanceof class_2627) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof class_1258) {
            return InventoryRenderType.FIXED_54;
        }
        if (inv instanceof class_10256) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof class_1694) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof class_2609) {
            return InventoryRenderType.FURNACE;
        }
        if (inv instanceof class_2589) {
            return InventoryRenderType.BREWING_STAND;
        }
        if (inv instanceof class_8887) {
            return InventoryRenderType.CRAFTER;
        }
        if (inv instanceof class_2601) {
            return InventoryRenderType.DISPENSER;
        }
        if (inv instanceof class_2614) {
            return InventoryRenderType.HOPPER;
        }
        if (inv instanceof class_1700) {
            return InventoryRenderType.HOPPER;
        }
        if (inv instanceof class_7716) {
            return InventoryRenderType.BOOKSHELF;
        }
        if (inv instanceof class_11597) {
            return InventoryRenderType.WALL_SHELF;
        }
        if (inv instanceof class_1661) {
            return InventoryRenderType.PLAYER;
        }
        if (inv instanceof IEntityOwnedInventory) {
            IEntityOwnedInventory inventory = (IEntityOwnedInventory)inv;
            if (inventory.malilib$getEntityOwner() instanceof class_1501) {
                return InventoryRenderType.LLAMA;
            }
            if (inventory.malilib$getEntityOwner() instanceof class_1493) {
                return InventoryRenderType.WOLF;
            }
            if (inventory.malilib$getEntityOwner() instanceof class_11573) {
                return InventoryRenderType.COPPER_GOLEM;
            }
            if (inventory.malilib$getEntityOwner() instanceof class_1496) {
                return InventoryRenderType.HORSE;
            }
            if (inventory.malilib$getEntityOwner() instanceof class_4836) {
                return InventoryRenderType.VILLAGER;
            }
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryRenderType getInventoryType(class_1799 stack) {
        class_1792 item = stack.method_7909();
        class_9288 container = (class_9288)stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        if (item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            if (block instanceof class_2480 || block instanceof class_2281 || block instanceof class_3708) {
                int size = ((IMixinContainerComponent)container).malilib_getStacks().size();
                if (size >= 0 && size <= 27) {
                    return InventoryRenderType.FIXED_27;
                }
                if (size > 27 && size <= 54) {
                    return InventoryRenderType.FIXED_54;
                }
                if (size > 54 && size < 256) {
                    return InventoryRenderType.GENERIC;
                }
            } else {
                if (block instanceof class_2363) {
                    return InventoryRenderType.FURNACE;
                }
                if (block instanceof class_2315) {
                    return InventoryRenderType.DISPENSER;
                }
                if (block instanceof class_2377) {
                    return InventoryRenderType.HOPPER;
                }
                if (block instanceof class_2260) {
                    return InventoryRenderType.BREWING_STAND;
                }
                if (block instanceof class_8886) {
                    return InventoryRenderType.CRAFTER;
                }
                if (block instanceof class_8168 || block instanceof class_2387 || block instanceof class_3715) {
                    return InventoryRenderType.SINGLE_ITEM;
                }
                if (block instanceof class_7714) {
                    return InventoryRenderType.BOOKSHELF;
                }
                if (block instanceof class_11586) {
                    return InventoryRenderType.WALL_SHELF;
                }
                if (block instanceof class_2336) {
                    return InventoryRenderType.ENDER_CHEST;
                }
            }
        } else if (item instanceof class_5537) {
            return InventoryRenderType.BUNDLE;
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryRenderType getInventoryType(@Nonnull class_2487 nbt) {
        class_1299<?> entityType;
        class_2591<?> blockType = NbtBlockUtils.getBlockEntityTypeFromNbt(nbt);
        if (blockType != null) {
            if (blockType.equals((Object)class_2591.field_11896) || blockType.equals((Object)class_2591.field_16411) || blockType.equals((Object)class_2591.field_11914) || blockType.equals((Object)class_2591.field_11891)) {
                class_2499 list;
                if (nbt.method_10545("Items") && (list = nbt.method_10554("Items").orElse(new class_2499())).size() > 27) {
                    return InventoryRenderType.FIXED_54;
                }
                return InventoryRenderType.FIXED_27;
            }
            if (blockType.equals((Object)class_2591.field_11903) || blockType.equals((Object)class_2591.field_16415) || blockType.equals((Object)class_2591.field_16414)) {
                return InventoryRenderType.FURNACE;
            }
            if (blockType.equals((Object)class_2591.field_11887) || blockType.equals((Object)class_2591.field_11899)) {
                return InventoryRenderType.DISPENSER;
            }
            if (blockType.equals((Object)class_2591.field_11888)) {
                return InventoryRenderType.HOPPER;
            }
            if (blockType.equals((Object)class_2591.field_11894)) {
                return InventoryRenderType.BREWING_STAND;
            }
            if (blockType.equals((Object)class_2591.field_46808)) {
                return InventoryRenderType.CRAFTER;
            }
            if (blockType.equals((Object)class_2591.field_42781) || blockType.equals((Object)class_2591.field_11907) || blockType.equals((Object)class_2591.field_16412)) {
                return InventoryRenderType.SINGLE_ITEM;
            }
            if (blockType.equals((Object)class_2591.field_40329)) {
                return InventoryRenderType.BOOKSHELF;
            }
            if (blockType.equals((Object)class_2591.field_61437)) {
                return InventoryRenderType.WALL_SHELF;
            }
            if (blockType.equals((Object)class_2591.field_11901)) {
                return InventoryRenderType.ENDER_CHEST;
            }
        }
        if ((entityType = NbtEntityUtils.getEntityTypeFromNbt(nbt)) != null) {
            if (entityType.equals((Object)class_1299.field_6126) || entityType.equals((Object)class_1299.field_54415) || entityType.equals((Object)class_1299.field_54418) || entityType.equals((Object)class_1299.field_54421) || entityType.equals((Object)class_1299.field_54423) || entityType.equals((Object)class_1299.field_54407) || entityType.equals((Object)class_1299.field_54413) || entityType.equals((Object)class_1299.field_54409) || entityType.equals((Object)class_1299.field_54411) || entityType.equals((Object)class_1299.field_54563) || entityType.equals((Object)class_1299.field_54417)) {
                return InventoryRenderType.FIXED_27;
            }
            if (entityType.equals((Object)class_1299.field_6058)) {
                return InventoryRenderType.HOPPER;
            }
            if (entityType.equals((Object)class_1299.field_6139) || entityType.equals((Object)class_1299.field_6067) || entityType.equals((Object)class_1299.field_6057) || entityType.equals((Object)class_1299.field_40116) || entityType.equals((Object)class_1299.field_6075) || entityType.equals((Object)class_1299.field_6048)) {
                return InventoryRenderType.HORSE;
            }
            if (entityType.equals((Object)class_1299.field_6074) || entityType.equals((Object)class_1299.field_17714)) {
                return InventoryRenderType.LLAMA;
            }
            if (entityType.equals((Object)class_1299.field_6055)) {
                return InventoryRenderType.WOLF;
            }
            if (entityType.equals((Object)class_1299.field_59668)) {
                return InventoryRenderType.HAPPY_GHAST;
            }
            if (entityType.equals((Object)class_1299.field_61221)) {
                return InventoryRenderType.COPPER_GOLEM;
            }
            if (entityType.equals((Object)class_1299.field_6077) || entityType.equals((Object)class_1299.field_38384) || entityType.equals((Object)class_1299.field_6105) || entityType.equals((Object)class_1299.field_22281) || entityType.equals((Object)class_1299.field_17713) || entityType.equals((Object)class_1299.field_6054)) {
                return InventoryRenderType.VILLAGER;
            }
            if (entityType.equals((Object)class_1299.field_6097)) {
                return InventoryRenderType.PLAYER;
            }
            if (entityType.equals((Object)class_1299.field_6131)) {
                return InventoryRenderType.ARMOR_STAND;
            }
            if (nbt.method_10545("attributes") || nbt.method_10545("active_effects") || nbt.method_10545("FallFlying")) {
                return InventoryRenderType.LIVING_ENTITY;
            }
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryRenderType getBestInventoryType(@Nonnull class_1263 inv, @Nonnull class_2487 nbt) {
        InventoryRenderType n;
        InventoryRenderType i = InventoryOverlay.getInventoryType(inv);
        if (i != (n = InventoryOverlay.getInventoryType(nbt)) && i == InventoryRenderType.GENERIC) {
            return n;
        }
        return i;
    }

    public static InventoryRenderType getBestInventoryType(@Nullable class_1263 inv, @Nonnull class_2487 nbt, Context ctx) {
        InventoryRenderType n;
        InventoryRenderType i = InventoryOverlay.getInventoryType(inv);
        if (i != (n = InventoryOverlay.getInventoryType(nbt)) && i == InventoryRenderType.GENERIC) {
            if (n != ctx.type() && ctx.type() != InventoryRenderType.GENERIC) {
                return ctx.type();
            }
            return n;
        }
        return i;
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryRenderType type, int totalSlots) {
        return InventoryOverlay.getInventoryPropsTemp(type, totalSlots, 9);
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryRenderType type, int totalSlots, int slotsPerARow) {
        InventoryOverlay.INV_PROPS_TEMP.totalSlots = totalSlots;
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 96;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 109;
            InventoryOverlay.INV_PROPS_TEMP.height = 72;
        } else if (type == InventoryRenderType.CRAFTER || type == InventoryRenderType.DISPENSER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HORSE || type == InventoryRenderType.LLAMA || type == InventoryRenderType.WOLF || type == InventoryRenderType.COPPER_GOLEM) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = Math.max(1, totalSlots / 3);
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = totalSlots * 18 / 3 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HOPPER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 5;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 105;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryRenderType.VILLAGER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 2;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 50;
            InventoryOverlay.INV_PROPS_TEMP.height = 86;
        } else if (type == InventoryRenderType.SINGLE_ITEM) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 32;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryRenderType.BOOKSHELF) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 50;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = 6;
        } else if (type == InventoryRenderType.WALL_SHELF) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 50;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = 3;
        } else if (type == InventoryRenderType.BUNDLE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = slotsPerARow != 9 ? MathUtils.clamp(slotsPerARow, 6, 9) : 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = rows * InventoryOverlay.INV_PROPS_TEMP.slotsPerRow;
        } else {
            if (type == InventoryRenderType.FIXED_27 || type == InventoryRenderType.PLAYER || type == InventoryRenderType.ENDER_CHEST) {
                totalSlots = 27;
            } else if (type == InventoryRenderType.FIXED_54) {
                totalSlots = 54;
            }
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
        }
        return INV_PROPS_TEMP;
    }

    public static void renderInventoryStacks(class_332 drawContext, InventoryRenderType type, class_1263 inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, class_310 mc) {
        InventoryOverlay.renderInventoryStacks(drawContext, type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), mc, 0.0, 0.0);
    }

    public static void renderInventoryStacks(class_332 drawContext, InventoryRenderType type, class_1263 inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots, class_310 mc) {
        InventoryOverlay.renderInventoryStacks(drawContext, type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, disabledSlots, mc, 0.0, 0.0);
    }

    public static void renderInventoryStacks(class_332 drawContext, InventoryRenderType type, class_1263 inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, class_310 mc, double mouseX, double mouseY) {
        InventoryOverlay.renderInventoryStacks(drawContext, type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), mc, mouseX, mouseY);
    }

    public static void renderInventoryStacks(class_332 drawContext, InventoryRenderType type, class_1263 inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots, class_310 mc, double mouseX, double mouseY) {
        if (inv == null) {
            inv = new class_1277(maxSlots > 0 ? maxSlots : InventoryOverlay.INV_PROPS_TEMP.totalSlots);
        }
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.renderStackAt(drawContext, inv.method_5438(0), startX + 8, startY + 8, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.method_5438(1), startX + 8, startY + 44, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.method_5438(2), startX + 68, startY + 26, 1.0f, mc, mouseX, mouseY);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.renderStackAt(drawContext, inv.method_5438(0), startX + 47, startY + 42, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.method_5438(1), startX + 70, startY + 49, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.method_5438(2), startX + 93, startY + 42, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.method_5438(3), startX + 70, startY + 8, 1.0f, mc, mouseX, mouseY);
            InventoryOverlay.renderStackAt(drawContext, inv.method_5438(4), startX + 8, startY + 8, 1.0f, mc, mouseX, mouseY);
        } else {
            int slots = inv.method_5439();
            int x = startX;
            int y = startY;
            if (maxSlots < 0) {
                maxSlots = slots;
            }
            int slot = startSlot;
            int i = 0;
            while (slot < slots && i < maxSlots) {
                for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                    class_1799 stack = inv.method_5438(slot).method_7972();
                    if (disabledSlots.contains(slot)) {
                        InventoryOverlay.renderLockedSlotAt(drawContext, x - 1, y - 1, 1.0f, mouseX, mouseY);
                    } else if (!stack.method_7960()) {
                        InventoryOverlay.renderStackAt(drawContext, stack, x, y, 1.0f, mc, mouseX, mouseY);
                    }
                    x += 18;
                }
                x = startX;
                y += 18;
            }
        }
        if (hoveredStack != null) {
            class_1799 stack = hoveredStack.method_7972();
            hoveredStack = null;
            InventoryOverlay.renderStackToolTipStyled(drawContext, (int)mouseX, (int)mouseY, stack, mc);
        }
    }

    public static void renderEquipmentStacks(class_332 drawContext, class_1309 entity, int x, int y, class_310 mc) {
        InventoryOverlay.renderEquipmentStacks(drawContext, entity, x, y, mc, 0.0, 0.0);
    }

    public static void renderEquipmentStacks(class_332 drawContext, class_1309 entity, int x, int y, class_310 mc, double mouseX, double mouseY) {
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            class_1304 eqSlot = VALID_EQUIPMENT_SLOTS[i];
            class_1799 stack = entity.method_6118(eqSlot);
            if (!stack.method_7960()) {
                InventoryOverlay.renderStackAt(drawContext, stack.method_7972(), x + xOff + 1, y + yOff + 1, 1.0f, mc, mouseX, mouseY);
            }
            ++i;
            yOff += 18;
        }
        class_1799 stack = entity.method_6118(class_1304.field_6173);
        if (!stack.method_7960()) {
            InventoryOverlay.renderStackAt(drawContext, stack.method_7972(), x + 28, y + 36 + 7 + 1, 1.0f, mc, mouseX, mouseY);
        }
        if (!(stack = entity.method_6118(class_1304.field_6171)).method_7960()) {
            InventoryOverlay.renderStackAt(drawContext, stack.method_7972(), x + 28, y + 54 + 7 + 1, 1.0f, mc, mouseX, mouseY);
        }
        if (hoveredStack != null) {
            stack = hoveredStack.method_7972();
            hoveredStack = null;
            InventoryOverlay.renderStackToolTipStyled(drawContext, (int)mouseX, (int)mouseY, stack, mc);
        }
    }

    public static void renderItemStacks(class_332 drawContext, class_2371<class_1799> items, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, class_310 mc) {
        InventoryOverlay.renderItemStacks(drawContext, items, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), mc);
    }

    public static void renderItemStacks(class_332 drawContext, class_2371<class_1799> items, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots, class_310 mc) {
        int slots = items.size();
        int x = startX;
        int y = startY;
        if (maxSlots < 0) {
            maxSlots = slots;
        }
        int slot = startSlot;
        int i = 0;
        while (slot < slots && i < maxSlots) {
            for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                class_1799 stack = ((class_1799)items.get(slot)).method_7972();
                if (disabledSlots.contains(slot)) {
                    InventoryOverlay.renderLockedSlotAt(drawContext, x - 1, y - 1, 1.0f, 0.0, 0.0);
                } else if (!stack.method_7960()) {
                    InventoryOverlay.renderStackAt(drawContext, stack, x, y, 1.0f, mc);
                }
                x += 18;
            }
            x = startX;
            y += 18;
        }
    }

    public static void renderStackAt(class_332 drawContext, class_1799 stack, float x, float y, float scale, class_310 mc) {
        InventoryOverlay.renderStackAt(drawContext, stack, x, y, scale, mc, 0.0, 0.0);
    }

    public static void renderStackAt(class_332 drawContext, class_1799 stack, float x, float y, float scale, class_310 mc, double mouseX, double mouseY) {
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        matrixStack.pushMatrix();
        matrixStack.translate(x, y);
        matrixStack.scale(scale, scale);
        drawContext.method_51427(stack.method_7972(), 0, 0);
        drawContext.method_51431(mc.field_1772, stack.method_7972(), 0, 0);
        matrixStack.popMatrix();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = stack.method_7972();
        }
    }

    public static void renderLockedSlotAt(class_332 drawContext, float x, float y, float scale, double mouseX, double mouseY) {
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        int color = -1;
        matrixStack.pushMatrix();
        matrixStack.translate(x, y);
        matrixStack.scale(scale, scale);
        color = -1;
        drawContext.method_52707(class_10799.field_56883, TEXTURE_LOCKED_SLOT, 0, 0, 18, 18, color);
        matrixStack.popMatrix();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = null;
        }
    }

    public static void renderBackgroundSlotAt(class_332 drawContext, class_2960 texture, float x, float y) {
        InventoryOverlay.renderBackgroundSlotAt(drawContext, texture, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderBackgroundSlotAt(class_332 drawContext, class_2960 texture, float x, float y, float scale, double mouseX, double mouseY) {
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        int color = -1;
        matrixStack.pushMatrix();
        matrixStack.translate(x, y);
        matrixStack.scale(scale, scale);
        color = -1;
        drawContext.method_52707(class_10799.field_56883, texture, 0, 0, 18, 18, color);
        matrixStack.popMatrix();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = null;
        }
    }

    public static void renderStackToolTip(class_332 drawContext, int x, int y, class_1799 stack, class_310 mc) {
        List list = stack.method_7950(class_1792.class_9635.method_59528((class_1937)mc.field_1687), (class_1657)mc.field_1724, (class_1836)(mc.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070));
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                lines.add(String.valueOf(stack.method_7932().method_58413()) + ((class_2561)list.get(i)).getString());
                continue;
            }
            lines.add(GuiBase.TXT_DARK_GRAY + ((class_2561)list.get(i)).getString());
        }
        RenderUtils.drawHoverText(drawContext, x, y, lines);
    }

    public static void renderStackToolTipStyled(class_332 drawContext, int x, int y, class_1799 stack, class_310 mc) {
        if (!stack.method_7960() && mc.field_1687 != null && mc.field_1724 != null) {
            List toolTips = stack.method_7950(class_1792.class_9635.method_59528((class_1937)WorldUtils.getBestWorld(mc)), (class_1657)mc.field_1724, (class_1836)(mc.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070));
            drawContext.method_51437(mc.field_1772, toolTips, stack.method_32347(), x, y, (class_2960)stack.method_58694(class_9334.field_54198));
            ((RenderEventHandler)RenderEventHandler.getInstance()).onRenderTooltipLast(drawContext, stack, x, y);
        }
    }

    private static void dumpStack(class_1799 stack, @Nullable List<class_2561> list) {
        if (stack.method_7960()) {
            LOGGER.info("dumpStack(): [{}]", class_1799.field_8037.toString());
            return;
        }
        LOGGER.info("dumpStack(): [{}}]", class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)stack).getPartialOrThrow());
        if (list != null && !list.isEmpty()) {
            int i = 0;
            for (class_2561 entry : list) {
                LOGGER.info("ToolTip[{}]: {}", i, entry.getString());
                ++i;
            }
        }
    }

    public static enum InventoryRenderType {
        BREWING_STAND,
        CRAFTER,
        DISPENSER,
        FURNACE,
        HOPPER,
        HORSE,
        LLAMA,
        WOLF,
        HAPPY_GHAST,
        COPPER_GOLEM,
        FIXED_27,
        FIXED_54,
        VILLAGER,
        PLAYER,
        ENDER_CHEST,
        BOOKSHELF,
        WALL_SHELF,
        SINGLE_ITEM,
        BUNDLE,
        ARMOR_STAND,
        LIVING_ENTITY,
        GENERIC;

    }

    public record Context(InventoryRenderType type, @Nullable class_1263 inv, @Nullable class_2586 be, @Nullable class_1309 entity, @Nullable class_2487 nbt, Refresher handler) {
    }

    public static class InventoryProperties {
        public int totalSlots = 1;
        public int width = 176;
        public int height = 83;
        public int slotsPerRow = 9;
        public int slotOffsetX = 8;
        public int slotOffsetY = 8;
    }

    public static interface Refresher {
        public Context onContextRefresh(Context var1, class_1937 var2);
    }
}

