/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.data.tag.util;

import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.DataView;
import fi.dy.masa.malilib.util.data.tag.DoubleData;
import fi.dy.masa.malilib.util.data.tag.IntData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public class DataTypeUtils {
    @Nullable
    public static UUID readUuidFromLongs(DataView tag) {
        return DataTypeUtils.readUuidFromLongs(tag, "UUIDM", "UUIDL");
    }

    @Nullable
    public static UUID readUuidFromLongs(DataView tag, String keyM, String keyL) {
        if (tag.contains(keyM, 4) && tag.contains(keyL, 4)) {
            return new UUID(tag.getLong(keyM), tag.getLong(keyL));
        }
        return null;
    }

    public static void writeUuidToLongs(CompoundData tag, UUID uuid) {
        DataTypeUtils.writeUuidToLongs(tag, uuid, "UUIDM", "UUIDL");
    }

    public static void writeUuidToLongs(CompoundData tag, UUID uuid, String keyM, String keyL) {
        tag.putLong(keyM, uuid.getMostSignificantBits());
        tag.putLong(keyL, uuid.getLeastSignificantBits());
    }

    public static CompoundData getOrCreateCompound(CompoundData tagIn, String tagName) {
        CompoundData tag;
        if (tagIn.contains(tagName, 10)) {
            tag = tagIn.getCompound(tagName);
        } else {
            tag = new CompoundData();
            tagIn.put(tagName, tag);
        }
        return tag;
    }

    public static <T> ListData asListTag(Collection<T> values, Function<T, BaseData> tagFactory) {
        ListData list = null;
        for (T val : values) {
            BaseData entry = tagFactory.apply(val);
            if (list == null) {
                list = new ListData(entry.getType());
            }
            list.add(entry);
        }
        return list;
    }

    public static CompoundData createVec3iTag(class_2382 pos) {
        return DataTypeUtils.putVec3i(new CompoundData(), pos);
    }

    public static CompoundData putVec3i(CompoundData tag, class_2382 pos) {
        tag.putInt("x", pos.method_10263());
        tag.putInt("y", pos.method_10264());
        tag.putInt("z", pos.method_10260());
        return tag;
    }

    @Nullable
    public static CompoundData writeVec3iToListTag(CompoundData tag, String tagName, class_2382 vec) {
        ListData list = new ListData(3);
        list.add(new IntData(vec.method_10263()));
        list.add(new IntData(vec.method_10264()));
        list.add(new IntData(vec.method_10260()));
        tag.put(tagName, list);
        return tag;
    }

    @Nullable
    public static CompoundData writeVec3iToArrayTag(CompoundData tag, String tagName, class_2382 vec) {
        int[] arr = new int[]{vec.method_10263(), vec.method_10264(), vec.method_10260()};
        tag.putIntArray(tagName, arr);
        return tag;
    }

    public static class_2382 readVec3iOrDefault(DataView tag, String vecTagName, class_2382 defaultValue) {
        if (!tag.contains(vecTagName, 10)) {
            return defaultValue;
        }
        CompoundData vecTag = tag.getCompound(vecTagName);
        if (vecTag.contains("x", 3) && vecTag.contains("y", 3) && vecTag.contains("z", 3)) {
            return new class_2382(vecTag.getInt("x"), vecTag.getInt("y"), vecTag.getInt("z"));
        }
        return defaultValue;
    }

    @Nullable
    public static class_2338 readBlockPos(DataView tag) {
        if (tag.contains("x", 3) && tag.contains("y", 3) && tag.contains("z", 3)) {
            return new class_2338(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
        }
        return null;
    }

    @Nullable
    public static class_2338 readBlockPosFromListTag(DataView tag, String tagName) {
        ListData list;
        if (tag.containsList(tagName, 3) && (list = tag.getList(tagName, 3)).size() == 3) {
            return new class_2338(list.getIntAt(0), list.getIntAt(1), list.getIntAt(2));
        }
        return null;
    }

    public static class_2338 readBlockPosFromListTagOrDefault(DataView tag, String tagName, class_2338 defaultValue) {
        class_2338 pos = DataTypeUtils.readBlockPosFromListTag(tag, tagName);
        return pos != null ? pos : defaultValue;
    }

    @Nullable
    public static class_2338 readBlockPosFromArrayTag(DataView tag, String tagName) {
        int[] pos;
        if (tag.contains(tagName, 11) && (pos = tag.getIntArray(tagName)).length == 3) {
            return new class_2338(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    public static class_2338 readBlockPosFromArrayTagOrDefault(DataView tag, String tagName, class_2338 defaultValue) {
        class_2338 pos = DataTypeUtils.readBlockPosFromArrayTag(tag, tagName);
        return pos != null ? pos : defaultValue;
    }

    public static CompoundData removeBlockPosFromTag(CompoundData tag) {
        tag.remove("x");
        tag.remove("y");
        tag.remove("z");
        return tag;
    }

    public static CompoundData writeVec3dToListTag(CompoundData tag, class_243 pos) {
        return DataTypeUtils.writeVec3dToListTag(tag, "Pos", pos);
    }

    public static CompoundData writeVec3dToListTag(CompoundData tag, String tagName, class_243 pos) {
        return DataTypeUtils.writeVec3dToListTag(tag, tagName, pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public static CompoundData writeVec3dToListTag(CompoundData tag, double x, double y, double z) {
        return DataTypeUtils.writeVec3dToListTag(tag, "Pos", x, y, z);
    }

    public static CompoundData writeVec3dToListTag(CompoundData tag, String tagName, double x, double y, double z) {
        ListData list = new ListData(6);
        list.add(new DoubleData(x));
        list.add(new DoubleData(y));
        list.add(new DoubleData(z));
        tag.put(tagName, list);
        return tag;
    }

    @Nullable
    public static class_243 readVec3d(DataView data) {
        if (data.contains("dx", 6) && data.contains("dy", 6) && data.contains("dz", 6)) {
            return new class_243(data.getDouble("dx"), data.getDouble("dy"), data.getDouble("dz"));
        }
        return null;
    }

    @Nullable
    public static class_243 readVec3dFromListTag(DataView data) {
        return DataTypeUtils.readVec3dFromListTag(data, "Pos");
    }

    @Nullable
    public static class_243 readVec3dFromListTag(DataView data, String tagName) {
        ListData list;
        if (data.containsList(tagName, 6) && (list = data.getList(tagName, 6)).size() == 3) {
            return new class_243(list.getDoubleAt(0), list.getDoubleAt(1), list.getDoubleAt(2));
        }
        return null;
    }
}

