/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.io;

import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.interfaces.TFileFilter;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import java.io.File;
import net.minecraft.class_2561;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class TExtensionFileFilter
implements TFileFilter {
    @Nullable
    private final String fileExtension;
    private final class_2561 description;

    public TExtensionFileFilter(@Nullable String fileExtension) {
        fileExtension = TExtensionFileFilter.sanitizeExtension(fileExtension);
        this.description = TCDCT.gui_explorer_fileFilter_extFiles((class_2561)TextUtils.literal(fileExtension));
        this.fileExtension = fileExtension.endsWith(".") ? null : fileExtension;
    }

    @Nullable
    public final String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public final class_2561 getDescription() {
        return this.description;
    }

    @Override
    public final boolean accept(File pathname) {
        try {
            if (pathname == null) {
                return false;
            }
            if (pathname.isDirectory() || this.fileExtension == null) {
                return true;
            }
            return pathname.getPath().endsWith(this.fileExtension);
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static String sanitizeExtension(String fileExtension) {
        fileExtension = (((String)(fileExtension = StringUtils.defaultString((String)fileExtension).replaceAll("[^a-zA-Z0-9.]", ""))).startsWith(".") ? "" : ".") + (String)fileExtension;
        return ((String)fileExtension).toLowerCase();
    }
}

