/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.tree;

import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Collection;
import java.util.Comparator;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.CoordinateSectionVisitor;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.BaseMultiForest;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.RemovableForest;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.RemovableTree;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.class_4076;

public class RemovableMultiForest
implements RemovableForest {
    private final Long2ReferenceLinkedOpenHashMap<RemovableTree> trees;
    private final ReferenceArrayList<RemovableTree> treeSortList = new ReferenceArrayList();
    private RemovableTree lastTree;
    private boolean treesAreReady = true;

    public RemovableMultiForest(float buildDistance) {
        this.trees = new Long2ReferenceLinkedOpenHashMap(RemovableMultiForest.getCapacity(buildDistance));
    }

    private static int getCapacity(float buildDistance) {
        int forestDim = BaseMultiForest.forestDimFromBuildDistance(buildDistance) + 1;
        return forestDim * forestDim * forestDim;
    }

    public void ensureCapacity(float buildDistance) {
        this.trees.ensureCapacity(RemovableMultiForest.getCapacity(buildDistance));
    }

    @Override
    public void prepareForTraversal() {
        if (this.treesAreReady) {
            return;
        }
        ObjectIterator it = this.trees.values().iterator();
        while (it.hasNext()) {
            RemovableTree tree = (RemovableTree)it.next();
            tree.prepareForTraversal();
            if (!tree.isEmpty()) continue;
            it.remove();
            if (this.lastTree != tree) continue;
            this.lastTree = null;
        }
        this.treesAreReady = true;
    }

    @Override
    public void traverse(CoordinateSectionVisitor visitor, Viewport viewport, float distanceLimit) {
        CameraTransform transform = viewport.getTransform();
        int cameraSectionX = transform.intX >> 4;
        int cameraSectionY = transform.intY >> 4;
        int cameraSectionZ = transform.intZ >> 4;
        this.treeSortList.clear();
        this.treeSortList.ensureCapacity(this.trees.size());
        this.treeSortList.addAll((Collection)this.trees.values());
        for (RemovableTree tree : this.treeSortList) {
            tree.updateSortKeyFor(cameraSectionX, cameraSectionY, cameraSectionZ);
        }
        this.treeSortList.unstableSort(Comparator.comparingInt(RemovableTree::getSortKey));
        for (RemovableTree tree : this.treeSortList) {
            tree.traverse(visitor, viewport, 0.0f, 0.0f);
        }
    }

    @Override
    public void add(int x, int y, int z) {
        this.treesAreReady = false;
        if (this.lastTree != null && this.lastTree.add(x, y, z)) {
            return;
        }
        int treeX = x >> 6;
        int treeY = y >> 6;
        int treeZ = z >> 6;
        long treeKey = class_4076.method_18685((int)treeX, (int)treeY, (int)treeZ);
        RemovableTree tree = (RemovableTree)this.trees.get(treeKey);
        if (tree == null) {
            int treeOffsetX = treeX << 6;
            int treeOffsetY = treeY << 6;
            int treeOffsetZ = treeZ << 6;
            tree = new RemovableTree(treeOffsetX, treeOffsetY, treeOffsetZ);
            this.trees.put(treeKey, (Object)tree);
        }
        tree.add(x, y, z);
        this.lastTree = tree;
    }

    @Override
    public void remove(int x, int y, int z) {
        this.treesAreReady = false;
        if (this.lastTree != null && this.lastTree.remove(x, y, z)) {
            return;
        }
        int treeX = x >> 6;
        int treeY = y >> 6;
        int treeZ = z >> 6;
        long treeKey = class_4076.method_18685((int)treeX, (int)treeY, (int)treeZ);
        RemovableTree tree = (RemovableTree)this.trees.get(treeKey);
        if (tree == null) {
            return;
        }
        tree.remove(x, y, z);
        this.lastTree = tree;
    }

    public void remove(RenderSection section) {
        this.remove(section.getChunkX(), section.getChunkY(), section.getChunkZ());
    }

    @Override
    public int getPresence(int x, int y, int z) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

