/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class ScarpetJsonDeserializer
implements JsonDeserializer<Value> {
    public Value deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return this.parseElement(json);
    }

    private Value parseElement(JsonElement element) throws JsonParseException {
        if (element.isJsonObject()) {
            return this.parseMap(element.getAsJsonObject());
        }
        if (element.isJsonArray()) {
            return this.parseList(element.getAsJsonArray());
        }
        if (element.isJsonPrimitive()) {
            return this.parsePrimitive(element.getAsJsonPrimitive());
        }
        return Value.NULL;
    }

    private Value parseMap(JsonObject jsonMap) throws JsonParseException {
        HashMap<Value, Value> map = new HashMap<Value, Value>();
        jsonMap.entrySet().forEach(entry -> map.put(new StringValue((String)entry.getKey()), this.parseElement((JsonElement)entry.getValue())));
        return MapValue.wrap(map);
    }

    private Value parseList(JsonArray jsonList) throws JsonParseException {
        ArrayList list = new ArrayList();
        jsonList.forEach(elem -> list.add(this.parseElement((JsonElement)elem)));
        return new ListValue(list);
    }

    private Value parsePrimitive(JsonPrimitive primitive) throws JsonParseException {
        if (primitive.isString()) {
            return new StringValue(primitive.getAsString());
        }
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean() ? Value.TRUE : Value.FALSE;
        }
        if (primitive.isNumber()) {
            return NumericValue.of(primitive.getAsNumber());
        }
        return Value.NULL;
    }
}

