/*
 * Decompiled with CFR 0.152.
 */
package de.daniel.bactromod.config;

import de.daniel.bactromod.config.ConfigData;
import de.daniel.bactromod.config.ConfigOption;
import java.lang.reflect.Field;

public class ConfigDefaults {
    public static ConfigData createDefaults() {
        ConfigData config = new ConfigData();
        for (Field f : ConfigData.class.getDeclaredFields()) {
            ConfigOption opt = f.getAnnotation(ConfigOption.class);
            if (opt == null) continue;
            try {
                f.setAccessible(true);
                if (f.getType() == Integer.TYPE) {
                    f.setInt(config, opt.intDefault());
                    continue;
                }
                if (f.getType() != Boolean.TYPE) continue;
                f.setBoolean(config, opt.boolDefault());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not set default for " + f.getName(), e);
            }
        }
        return config;
    }
}

