/*
 * Decompiled with CFR 0.152.
 */
package de.daniel.bactromod.windowborder;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import de.daniel.bactromod.config.Config;
import de.daniel.bactromod.config.ConfigData;
import de.daniel.bactromod.windowborder.WindowUtil;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.system.NativeType;

public interface DwmApi
extends Library {
    public static final DwmApi INSTANCE = (DwmApi)Native.load((String)"dwmapi", DwmApi.class);
    public static final int INT_SIZE = 4;
    public static final int DWMWA_USE_IMMERSIVE_DARK_MODE = 20;
    public static final int DWMWA_WINDOW_CORNER_PREFERENCE = 33;
    public static final int DWMWA_BORDER_COLOR = 34;
    public static final int DWMWA_CAPTION_COLOR = 35;
    public static final int DWMWA_TEXT_COLOR = 36;
    public static final int DWMWA_SYSTEMBACKDROP_TYPE = 38;
    public static final int DWMWA_COLOR_DEFAULT = -1;

    @NativeType(value="HRESULT")
    public void DwmSetWindowAttribute(WinDef.HWND var1, int var2, PointerType var3, int var4);

    public static void updateDwm(long window) {
        if (!WindowUtil.checkCompatibility()) {
            return;
        }
        WinDef.HWND hwnd = new WinDef.HWND(Pointer.createConstant((long)GLFWNativeWin32.glfwGetWin32Window((long)window)));
        ConfigData config = Config.load();
        INSTANCE.DwmSetWindowAttribute(hwnd, 20, (PointerType)new IntByReference(config.darkWindowBorders ? 1 : 0), 4);
        if (WindowUtil.buildNumber >= 22621) {
            INSTANCE.DwmSetWindowAttribute(hwnd, 38, (PointerType)new IntByReference(DWM_SYSTEMBACKDROP_TYPE.DWMSBT_AUTO.ordinal()), 4);
        }
        INSTANCE.DwmSetWindowAttribute(hwnd, 33, (PointerType)new IntByReference(DWM_WINDOW_CORNER_PREFERENCE.DWMWCP_DEFAULT.ordinal()), 4);
        INSTANCE.DwmSetWindowAttribute(hwnd, 34, (PointerType)new IntByReference(-1), 4);
        INSTANCE.DwmSetWindowAttribute(hwnd, 35, (PointerType)new IntByReference(-1), 4);
        INSTANCE.DwmSetWindowAttribute(hwnd, 36, (PointerType)new IntByReference(-1), 4);
    }

    public static enum DWM_SYSTEMBACKDROP_TYPE {
        DWMSBT_AUTO("auto");

        public final String translate;

        private DWM_SYSTEMBACKDROP_TYPE(String translate) {
            this.translate = translate;
        }
    }

    public static enum DWM_WINDOW_CORNER_PREFERENCE {
        DWMWCP_DEFAULT("default");

        public final String translate;

        private DWM_WINDOW_CORNER_PREFERENCE(String translate) {
            this.translate = translate;
        }
    }
}

