/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigBooleanHotkeyed;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigFloat;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.time.DurationFormat;
import fi.dy.masa.malilib.util.time.TimeFormat;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.config.StructureToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererStructures;
import fi.dy.masa.minihud.util.BlockGridMode;
import fi.dy.masa.minihud.util.CopperAgingMode;
import fi.dy.masa.minihud.util.LightLevelMarkerMode;
import fi.dy.masa.minihud.util.LightLevelNumberMode;
import fi.dy.masa.minihud.util.LightLevelRenderCondition;
import fi.dy.masa.minihud.util.SpeedUnits;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class Configs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "minihud.json";
    private static final int CONFIG_VERSION = 1;
    private static final String GENERIC_KEY = "minihud.config.generic";
    private static final String COLORS_KEY = "minihud.config.colors";

    public static void loadFromFile() {
        Path configFile = FileUtils.getConfigDirectoryAsPath().resolve(CONFIG_FILE_NAME);
        if (Files.exists(configFile, new LinkOption[0]) && Files.isReadable(configFile)) {
            JsonElement element = JsonUtils.parseJsonFileAsPath((Path)configFile);
            if (element != null && element.isJsonObject()) {
                JsonObject root = element.getAsJsonObject();
                JsonObject objInfoLineOrders = JsonUtils.getNestedObject((JsonObject)root, (String)"InfoLineOrders", (boolean)false);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"Colors", Colors.OPTIONS);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"Generic", Generic.OPTIONS);
                ConfigUtils.readHotkeyToggleOptions((JsonObject)root, (String)"InfoHotkeys", (String)"InfoTypeToggles", InfoToggle.VALUES);
                ConfigUtils.readHotkeyToggleOptions((JsonObject)root, (String)"RendererHotkeys", (String)"RendererToggles", RendererToggle.VALUES);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"StructureColors", StructureToggle.COLOR_CONFIGS);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"StructureHotkeys", StructureToggle.HOTKEY_CONFIGS);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"StructureToggles", StructureToggle.TOGGLE_CONFIGS);
                int version = JsonUtils.getIntegerOrDefault((JsonObject)root, (String)"config_version", (int)0);
                if (objInfoLineOrders != null && version >= 1) {
                    for (InfoToggle toggle : InfoToggle.VALUES) {
                        if (!JsonUtils.hasInteger((JsonObject)objInfoLineOrders, (String)toggle.getName())) continue;
                        toggle.setIntegerValue(JsonUtils.getInteger((JsonObject)objInfoLineOrders, (String)toggle.getName()));
                    }
                }
            } else {
                MiniHUD.LOGGER.error("loadFromFile(): Failed to load config file '{}'.", (Object)configFile.toAbsolutePath());
            }
            OverlayRendererLightLevel.INSTANCE.setRenderThrough(Generic.LIGHT_LEVEL_RENDER_THROUGH.getBooleanValue());
            OverlayRendererStructures.INSTANCE.setRenderThrough(Generic.STRUCTURES_RENDER_THROUGH.getBooleanValue());
        }
    }

    public static void saveToFile() {
        Path dir = FileUtils.getConfigDirectoryAsPath();
        if (!Files.exists(dir, new LinkOption[0])) {
            FileUtils.createDirectoriesIfMissing((Path)dir);
        }
        if (Files.isDirectory(dir, new LinkOption[0])) {
            JsonObject root = new JsonObject();
            JsonObject objInfoLineOrders = JsonUtils.getNestedObject((JsonObject)root, (String)"InfoLineOrders", (boolean)true);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Colors", Colors.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Generic", Generic.OPTIONS);
            ConfigUtils.writeHotkeyToggleOptions((JsonObject)root, (String)"InfoHotkeys", (String)"InfoTypeToggles", InfoToggle.VALUES);
            ConfigUtils.writeHotkeyToggleOptions((JsonObject)root, (String)"RendererHotkeys", (String)"RendererToggles", RendererToggle.VALUES);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"StructureColors", StructureToggle.COLOR_CONFIGS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"StructureHotkeys", StructureToggle.HOTKEY_CONFIGS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"StructureToggles", StructureToggle.TOGGLE_CONFIGS);
            if (objInfoLineOrders != null) {
                for (InfoToggle toggle : InfoToggle.VALUES) {
                    objInfoLineOrders.add(toggle.getName(), (JsonElement)new JsonPrimitive((Number)toggle.getIntegerValue()));
                }
            }
            root.add("config_version", (JsonElement)new JsonPrimitive((Number)1));
            JsonUtils.writeJsonToFileAsPath((JsonObject)root, (Path)dir.resolve(CONFIG_FILE_NAME));
        } else {
            MiniHUD.LOGGER.error("saveToFile(): Config Folder '{}' does not exist!", (Object)dir.toAbsolutePath());
        }
    }

    public void load() {
        Configs.loadFromFile();
    }

    public void save() {
        Configs.saveToFile();
    }

    public static class Colors {
        public static final ConfigColor BEACON_RANGE_LVL1_OVERLAY_COLOR = new ConfigColor("beaconRangeLvl1", "#20E060FF").apply("minihud.config.colors");
        public static final ConfigColor BEACON_RANGE_LVL2_OVERLAY_COLOR = new ConfigColor("beaconRangeLvl2", "#20FFB040").apply("minihud.config.colors");
        public static final ConfigColor BEACON_RANGE_LVL3_OVERLAY_COLOR = new ConfigColor("beaconRangeLvl3", "#20FFF040").apply("minihud.config.colors");
        public static final ConfigColor BEACON_RANGE_LVL4_OVERLAY_COLOR = new ConfigColor("beaconRangeLvl4", "#2060FF40").apply("minihud.config.colors");
        public static final ConfigColor BLOCK_GRID_OVERLAY_COLOR = new ConfigColor("blockGridOverlayColor", "#80FFFFFF").apply("minihud.config.colors");
        public static final ConfigColor CONDUIT_RANGE_OVERLAY_COLOR = new ConfigColor("conduitRange", "#2030FFFF").apply("minihud.config.colors");
        public static final ConfigColor CONDUIT_RANGE_OUTLINES = new ConfigColor("conduitRangeOutlines", "#80FFFFFF").apply("minihud.config.colors");
        public static final ConfigColor LIGHT_LEVEL_MARKER_BLOCK_LIT = new ConfigColor("lightLevelMarkerBlockLit", "#FF209040").apply("minihud.config.colors");
        public static final ConfigColor LIGHT_LEVEL_MARKER_DARK = new ConfigColor("lightLevelMarkerDark", "#FFFF4848").apply("minihud.config.colors");
        public static final ConfigColor LIGHT_LEVEL_MARKER_DIM = new ConfigColor("lightLevelMarkerDim", "#FFC0C040").apply("minihud.config.colors");
        public static final ConfigColor LIGHT_LEVEL_MARKER_SKY_LIT = new ConfigColor("lightLevelMarkerSkyLit", "#FFFFFF33").apply("minihud.config.colors");
        public static final ConfigColor LIGHT_LEVEL_NUMBER_BLOCK_DARK = new ConfigColor("lightLevelNumberBlockDark", "#FFC03030").apply("minihud.config.colors");
        public static final ConfigColor LIGHT_LEVEL_NUMBER_BLOCK_DIM = new ConfigColor("lightLevelNumberBlockDim", "#FFC0C040").apply("minihud.config.colors");
        public static final ConfigColor LIGHT_LEVEL_NUMBER_BLOCK_LIT = new ConfigColor("lightLevelNumberBlockLit", "#FF20FF40").apply("minihud.config.colors");
        public static final ConfigColor LIGHT_LEVEL_NUMBER_SKY_DARK = new ConfigColor("lightLevelNumberSkyDark", "#FFFFF030").apply("minihud.config.colors");
        public static final ConfigColor LIGHT_LEVEL_NUMBER_SKY_DIM = new ConfigColor("lightLevelNumberSkyDim", "#FFC0C030").apply("minihud.config.colors");
        public static final ConfigColor LIGHT_LEVEL_NUMBER_SKY_LIT = new ConfigColor("lightLevelNumberSkyLit", "#FF40E0FF").apply("minihud.config.colors");
        public static final ConfigColor RANDOM_TICKS_FIXED_OVERLAY_COLOR = new ConfigColor("randomTicksFixedOverlayColor", "#30F9F225").apply("minihud.config.colors");
        public static final ConfigColor RANDOM_TICKS_PLAYER_OVERLAY_COLOR = new ConfigColor("randomTicksPlayerOverlayColor", "#3030FE73").apply("minihud.config.colors");
        public static final ConfigColor REGION_OVERLAY_COLOR = new ConfigColor("regionOverlayColor", "#30FF8019").apply("minihud.config.colors");
        public static final ConfigColor SHAPE_ADJUSTABLE_SPAWN_SPHERE = new ConfigColor("shapeAdjustableSpawnSphere", "#6030B0B0").apply("minihud.config.colors");
        public static final ConfigColor SHAPE_BOX = new ConfigColor("shapeBox", "#6050A0A0").apply("minihud.config.colors");
        public static final ConfigColor SHAPE_CAN_DESPAWN_SPHERE = new ConfigColor("shapeCanDespawnSphere", "#60A04050").apply("minihud.config.colors");
        public static final ConfigColor SHAPE_CAN_SPAWN_SPHERE = new ConfigColor("shapeCanSpawnSphere", "#60A04050").apply("minihud.config.colors");
        public static final ConfigColor SHAPE_CIRCLE = new ConfigColor("shapeCircle", "#6030B0B0").apply("minihud.config.colors");
        public static final ConfigColor SHAPE_DESPAWN_SPHERE = new ConfigColor("shapeDespawnSphere", "#60A04050").apply("minihud.config.colors");
        public static final ConfigColor SHAPE_LINE_BLOCKY = new ConfigColor("shapeLineBlocky", "#6030F0B0").apply("minihud.config.colors");
        public static final ConfigColor SHAPE_SPHERE_BLOCKY = new ConfigColor("shapeSphereBlocky", "#6030B0B0").apply("minihud.config.colors");
        public static final ConfigColor SLIME_CHUNKS_OVERLAY_COLOR = new ConfigColor("slimeChunksOverlayColor", "#3020F020").apply("minihud.config.colors");
        public static final ConfigColor SPAWN_PLAYER_ENTITY_OVERLAY_COLOR = new ConfigColor("spawnPlayerEntityOverlayColor", "#302050D0").apply("minihud.config.colors");
        public static final ConfigColor SPAWN_PLAYER_REDSTONE_OVERLAY_COLOR = new ConfigColor("spawnPlayerRedstoneOverlayColor", "#30F8D641").apply("minihud.config.colors");
        public static final ConfigColor SPAWN_PLAYER_LAZY_OVERLAY_COLOR = new ConfigColor("spawnPlayerLazyOverlayColor", "#30D030D0").apply("minihud.config.colors");
        public static final ConfigColor SPAWN_PLAYER_OUTER_OVERLAY_COLOR = new ConfigColor("spawnPlayerOuterOverlayColor", "#306900D2").apply("minihud.config.colors");
        public static final ConfigColor SPAWN_REAL_ENTITY_OVERLAY_COLOR = new ConfigColor("spawnRealEntityOverlayColor", "#3030FF20").apply("minihud.config.colors");
        public static final ConfigColor SPAWNABLE_COLUMNS_OVERLAY_COLOR = new ConfigColor("spawnableColumnHeightsOverlayColor", "#A0FF00FF").apply("minihud.config.colors");
        public static final ConfigColor TEXT_BACKGROUND_COLOR = new ConfigColor("textBackgroundColor", "#A0505050").apply("minihud.config.colors");
        public static final ConfigColor TEXT_COLOR = new ConfigColor("textColor", "#FFE0E0E0").apply("minihud.config.colors");
        public static final ImmutableList<IConfigValue> OPTIONS = ImmutableList.of((Object)BEACON_RANGE_LVL1_OVERLAY_COLOR, (Object)BEACON_RANGE_LVL2_OVERLAY_COLOR, (Object)BEACON_RANGE_LVL3_OVERLAY_COLOR, (Object)BEACON_RANGE_LVL4_OVERLAY_COLOR, (Object)BLOCK_GRID_OVERLAY_COLOR, (Object)CONDUIT_RANGE_OVERLAY_COLOR, (Object)CONDUIT_RANGE_OUTLINES, (Object)LIGHT_LEVEL_MARKER_BLOCK_LIT, (Object)LIGHT_LEVEL_MARKER_DARK, (Object)LIGHT_LEVEL_MARKER_DIM, (Object)LIGHT_LEVEL_MARKER_SKY_LIT, (Object)LIGHT_LEVEL_NUMBER_BLOCK_DARK, (Object[])new IConfigValue[]{LIGHT_LEVEL_NUMBER_BLOCK_DIM, LIGHT_LEVEL_NUMBER_BLOCK_LIT, LIGHT_LEVEL_NUMBER_SKY_DARK, LIGHT_LEVEL_NUMBER_SKY_DIM, LIGHT_LEVEL_NUMBER_SKY_LIT, RANDOM_TICKS_FIXED_OVERLAY_COLOR, RANDOM_TICKS_PLAYER_OVERLAY_COLOR, REGION_OVERLAY_COLOR, SHAPE_ADJUSTABLE_SPAWN_SPHERE, SHAPE_BOX, SHAPE_CAN_DESPAWN_SPHERE, SHAPE_CAN_SPAWN_SPHERE, SHAPE_CIRCLE, SHAPE_DESPAWN_SPHERE, SHAPE_LINE_BLOCKY, SHAPE_SPHERE_BLOCKY, SLIME_CHUNKS_OVERLAY_COLOR, SPAWN_PLAYER_ENTITY_OVERLAY_COLOR, SPAWN_PLAYER_REDSTONE_OVERLAY_COLOR, SPAWN_PLAYER_LAZY_OVERLAY_COLOR, SPAWN_PLAYER_OUTER_OVERLAY_COLOR, SPAWN_REAL_ENTITY_OVERLAY_COLOR, SPAWNABLE_COLUMNS_OVERLAY_COLOR, TEXT_BACKGROUND_COLOR, TEXT_COLOR});
    }

    public static class Generic {
        public static final ConfigBoolean AXOLOTL_TOOLTIPS = (ConfigBoolean)new ConfigBoolean("axolotlTooltips", false).apply("minihud.config.generic");
        public static final ConfigBoolean BEE_TOOLTIPS = (ConfigBoolean)new ConfigBoolean("beeTooltips", false).apply("minihud.config.generic");
        public static final ConfigBoolean DISABLE_VANILLA_BEE_TOOLTIPS = (ConfigBoolean)new ConfigBoolean("disableVanillaBeeTooltips", false).apply("minihud.config.generic");
        public static final ConfigBoolean BUNDLE_TOOLTIPS = (ConfigBoolean)new ConfigBoolean("bundleTooltips", true).apply("minihud.config.generic");
        public static final ConfigInteger BUNDLE_TOOLTIPS_FILL_LEVEL = (ConfigInteger)new ConfigInteger("bundleTooltipsFillLevel", 64, 1, 64).apply("minihud.config.generic");
        public static final ConfigBoolean CUSTOM_MODEL_TOOLTIPS = (ConfigBoolean)new ConfigBoolean("customModelTooltips", false).apply("minihud.config.generic");
        public static final ConfigBoolean FOOD_TOOLTIPS = (ConfigBoolean)new ConfigBoolean("foodTooltips", false).apply("minihud.config.generic");
        public static final ConfigBoolean HONEY_TOOLTIPS = (ConfigBoolean)new ConfigBoolean("honeyTooltips", false).apply("minihud.config.generic");
        public static final ConfigBoolean LODESTONE_TOOLTIPS = (ConfigBoolean)new ConfigBoolean("lodestoneTooltips", false).apply("minihud.config.generic");
        public static final ConfigInteger BIOME_OVERLAY_RANGE = (ConfigInteger)new ConfigInteger("biomeOverlayRange", 4, 0, 32).apply("minihud.config.generic");
        public static final ConfigInteger BIOME_OVERLAY_RANGE_VERTICAL = (ConfigInteger)new ConfigInteger("biomeOverlayRangeVertical", 0, 0, 32).apply("minihud.config.generic");
        public static final ConfigBoolean BIOME_OVERLAY_SINGLE_COLOR = (ConfigBoolean)new ConfigBoolean("biomeOverlaySingleColor", true).apply("minihud.config.generic");
        public static final ConfigString BLOCK_POS_FORMAT_STRING = (ConfigString)new ConfigString("blockPosFormat", "Block: %d, %d, %d").apply("minihud.config.generic");
        public static final ConfigOptionList BLOCK_GRID_OVERLAY_MODE = (ConfigOptionList)new ConfigOptionList("blockGridOverlayMode", (IConfigOptionListEntry)BlockGridMode.ALL).apply("minihud.config.generic");
        public static final ConfigInteger BLOCK_GRID_OVERLAY_RADIUS = (ConfigInteger)new ConfigInteger("blockGridOverlayRadius", 32, 0, 128).apply("minihud.config.generic");
        public static final ConfigBoolean BUNDLE_PREVIEW = (ConfigBoolean)new ConfigBoolean("bundlePreview", false).apply("minihud.config.generic");
        public static final ConfigBoolean BUNDLE_DISPLAY_BACKGROUND_COLOR = (ConfigBoolean)new ConfigBoolean("bundleDisplayBgColor", true).apply("minihud.config.generic");
        public static final ConfigBoolean BUNDLE_DISPLAY_REQUIRE_SHIFT = (ConfigBoolean)new ConfigBoolean("bundleDisplayRequireShift", true).apply("minihud.config.generic");
        public static final ConfigInteger BUNDLE_DISPLAY_ROW_WIDTH = (ConfigInteger)new ConfigInteger("bundleDisplayRowWidth", 9, 6, 9).apply("minihud.config.generic");
        public static final ConfigBoolean CONDUIT_RANGE_OVERLAY_COMBINE_QUADS = (ConfigBoolean)new ConfigBoolean("conduitRangeOverlayCombineQuads", true).apply("minihud.config.generic");
        public static final ConfigBoolean CONDUIT_RANGE_OVERLAY_RENDER_OUTLINES = (ConfigBoolean)new ConfigBoolean("conduitRangeOverlayOutlines", false).apply("minihud.config.generic");
        public static final ConfigBoolean CONDUIT_RANGE_OVERLAY_RENDER_THROUGH = (ConfigBoolean)new ConfigBoolean("conduitRangeOverlayThrough", false).apply("minihud.config.generic");
        public static final ConfigString COORDINATE_FORMAT_STRING = (ConfigString)new ConfigString("coordinateFormat", "x: %.1f y: %.1f z: %.1f").apply("minihud.config.generic");
        public static final ConfigOptionList COPPER_AGING_MODE = (ConfigOptionList)new ConfigOptionList("copperAgingMode", (IConfigOptionListEntry)CopperAgingMode.MC_TIME).apply("minihud.config.generic");
        public static final ConfigOptionList DATE_FORMAT_TYPE = (ConfigOptionList)new ConfigOptionList("dateFormatType", (IConfigOptionListEntry)TimeFormat.REGULAR).apply("minihud.config.generic");
        public static final ConfigString DATE_FORMAT_STRING = (ConfigString)new ConfigString("dateFormatString", "yyyy-MM-dd HH:mm:ss").apply("minihud.config.generic");
        public static final ConfigString DATE_FORMAT_MINECRAFT = (ConfigString)new ConfigString("dateFormatMinecraft", "MC time: (day {DAY}) {HOUR}:{MIN}:xx").apply("minihud.config.generic");
        public static final ConfigOptionList DURATION_FORMAT_TYPE = (ConfigOptionList)new ConfigOptionList("durationFormatType", (IConfigOptionListEntry)DurationFormat.PRETTY).apply("minihud.config.generic");
        public static final ConfigString DURATION_FORMAT_STRING = (ConfigString)new ConfigString("durationFormatString", "HH:mm:ss.SSS").apply("minihud.config.generic");
        public static final ConfigBoolean DEBUG_MESSAGES = (ConfigBoolean)new ConfigBoolean("debugMessages", false).apply("minihud.config.generic");
        public static final ConfigBoolean DONT_RESET_SEED_ON_DIMENSION_CHANGE = (ConfigBoolean)new ConfigBoolean("dontClearStoredSeedOnDimensionChange", true).apply("minihud.config.generic");
        public static final ConfigBooleanHotkeyed ENTITY_DATA_SYNC = new ConfigBooleanHotkeyed("entityDataSync", false, "").apply("minihud.config.generic");
        public static final ConfigBoolean ENTITY_DATA_SYNC_BACKUP = (ConfigBoolean)new ConfigBoolean("entityDataSyncBackup", false).apply("minihud.config.generic");
        public static final ConfigBoolean ENTITY_DATA_SYNC_BACKUP_OPEN_TO_LAN = (ConfigBoolean)new ConfigBoolean("entityDataSyncBackupOpenToLan", false).apply("minihud.config.generic");
        public static final ConfigFloat ENTITY_DATA_SYNC_CACHE_REFRESH = (ConfigFloat)new ConfigFloat("entityDataSyncCacheRefresh", 0.25f, 0.05f, 1.0f).apply("minihud.config.generic");
        public static final ConfigFloat ENTITY_DATA_SYNC_CACHE_TIMEOUT = (ConfigFloat)new ConfigFloat("entityDataSyncCacheTimeout", 0.75f, 0.25f, 5.0f).apply("minihud.config.generic");
        public static final ConfigDouble FONT_SCALE = (ConfigDouble)new ConfigDouble("fontScale", 0.5, 0.01, 100.0).apply("minihud.config.generic");
        public static final ConfigOptionList HUD_ALIGNMENT = (ConfigOptionList)new ConfigOptionList("hudAlignment", (IConfigOptionListEntry)HudAlignment.TOP_LEFT).apply("minihud.config.generic");
        public static final ConfigBooleanHotkeyed HUD_DATA_SYNC = new ConfigBooleanHotkeyed("hudDataSync", false, "").apply("minihud.config.generic");
        public static final ConfigBooleanHotkeyed HUD_STATUS_EFFECTS_SHIFT = new ConfigBooleanHotkeyed("hudStatusEffectsShift", true, "").apply("minihud.config.generic");
        public static final ConfigHotkey INVENTORY_PREVIEW = (ConfigHotkey)new ConfigHotkey("inventoryPreview", "LEFT_ALT", KeybindSettings.PRESS_ALLOWEXTRA).apply("minihud.config.generic");
        public static final ConfigBoolean INVENTORY_PREVIEW_ENABLED = (ConfigBoolean)new ConfigBoolean("inventoryPreviewEnabled", false).apply("minihud.config.generic");
        public static final ConfigHotkey INVENTORY_PREVIEW_TOGGLE_SCREEN = (ConfigHotkey)new ConfigHotkey("inventoryPreviewToggleScreen", "BUTTON_3", KeybindSettings.create((KeybindSettings.Context)KeybindSettings.Context.ANY, (KeyAction)KeyAction.PRESS, (boolean)true, (boolean)true, (boolean)false, (boolean)true)).apply("minihud.config.generic");
        public static final ConfigBoolean INVENTORY_PREVIEW_VILLAGER_BG_COLOR = (ConfigBoolean)new ConfigBoolean("inventoryPreviewVillagerBGColor", false).apply("minihud.config.generic");
        public static final ConfigBoolean LIGHT_LEVEL_AUTO_HEIGHT = (ConfigBoolean)new ConfigBoolean("lightLevelAutoHeight", false).apply("minihud.config.generic");
        public static final ConfigBoolean LIGHT_LEVEL_COLORED_NUMBERS = (ConfigBoolean)new ConfigBoolean("lightLevelColoredNumbers", true).apply("minihud.config.generic");
        public static final ConfigBoolean LIGHT_LEVEL_COLLISION_CHECK = (ConfigBoolean)new ConfigBoolean("lightLevelCollisionCheck", false).apply("minihud.config.generic");
        public static final ConfigOptionList LIGHT_LEVEL_MARKER_CONDITION = (ConfigOptionList)new ConfigOptionList("lightLevelMarkerCondition", (IConfigOptionListEntry)LightLevelRenderCondition.SPAWNABLE).apply("minihud.config.generic");
        public static final ConfigOptionList LIGHT_LEVEL_MARKER_MODE = (ConfigOptionList)new ConfigOptionList("lightLevelMarkers", (IConfigOptionListEntry)LightLevelMarkerMode.SQUARE).apply("minihud.config.generic");
        public static final ConfigDouble LIGHT_LEVEL_MARKER_SIZE = (ConfigDouble)new ConfigDouble("lightLevelMarkerSize", 0.84, 0.0, 1.0).apply("minihud.config.generic");
        public static final ConfigOptionList LIGHT_LEVEL_NUMBER_CONDITION = (ConfigOptionList)new ConfigOptionList("lightLevelNumberCondition", (IConfigOptionListEntry)LightLevelRenderCondition.ALWAYS).apply("minihud.config.generic");
        public static final ConfigOptionList LIGHT_LEVEL_NUMBER_MODE = (ConfigOptionList)new ConfigOptionList("lightLevelNumbers", (IConfigOptionListEntry)LightLevelNumberMode.BLOCK).apply("minihud.config.generic");
        public static final ConfigDouble LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_X = (ConfigDouble)new ConfigDouble("lightLevelNumberOffsetBlockX", 0.26, 0.0, 1.0).apply("minihud.config.generic");
        public static final ConfigDouble LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_Y = (ConfigDouble)new ConfigDouble("lightLevelNumberOffsetBlockY", 0.32, 0.0, 1.0).apply("minihud.config.generic");
        public static final ConfigDouble LIGHT_LEVEL_NUMBER_OFFSET_SKY_X = (ConfigDouble)new ConfigDouble("lightLevelNumberOffsetSkyX", 0.42, 0.0, 1.0).apply("minihud.config.generic");
        public static final ConfigDouble LIGHT_LEVEL_NUMBER_OFFSET_SKY_Y = (ConfigDouble)new ConfigDouble("lightLevelNumberOffsetSkyY", 0.56, 0.0, 1.0).apply("minihud.config.generic");
        public static final ConfigBoolean LIGHT_LEVEL_NUMBER_ROTATION = (ConfigBoolean)new ConfigBoolean("lightLevelNumberRotation", true).apply("minihud.config.generic");
        public static final ConfigInteger LIGHT_LEVEL_RANGE = (ConfigInteger)new ConfigInteger("lightLevelRange", 24, 1, 64).apply("minihud.config.generic");
        public static final ConfigDouble LIGHT_LEVEL_RENDER_OFFSET = (ConfigDouble)new ConfigDouble("lightLevelRenderOffset", 0.005, 0.0, 1.0).apply("minihud.config.generic");
        public static final ConfigBoolean LIGHT_LEVEL_RENDER_THROUGH = (ConfigBoolean)new ConfigBoolean("lightLevelRenderThrough", false).apply("minihud.config.generic");
        public static final ConfigBoolean LIGHT_LEVEL_SKIP_BLOCK_CHECK = (ConfigBoolean)new ConfigBoolean("lightLevelSkipBlockCheck", false).apply("minihud.config.generic");
        public static final ConfigInteger LIGHT_LEVEL_THRESHOLD_DIM = (ConfigInteger)new ConfigInteger("lightLevelThresholdDim", 0, 0, 15).apply("minihud.config.generic");
        public static final ConfigInteger LIGHT_LEVEL_THRESHOLD_SAFE = (ConfigInteger)new ConfigInteger("lightLevelThresholdSafe", 1, 0, 15).apply("minihud.config.generic");
        public static final ConfigBoolean LIGHT_LEVEL_UNDER_WATER = (ConfigBoolean)new ConfigBoolean("lightLevelUnderWater", false).apply("minihud.config.generic");
        public static final ConfigBooleanHotkeyed MAIN_RENDERING_TOGGLE = new ConfigBooleanHotkeyed("mainRenderingToggle", true, "H", KeybindSettings.RELEASE_EXCLUSIVE).apply("minihud.config.generic");
        public static final ConfigBoolean MAP_PREVIEW = (ConfigBoolean)new ConfigBoolean("mapPreview", false).apply("minihud.config.generic");
        public static final ConfigBoolean MAP_PREVIEW_REQUIRE_SHIFT = (ConfigBoolean)new ConfigBoolean("mapPreviewRequireShift", true).apply("minihud.config.generic");
        public static final ConfigInteger MAP_PREVIEW_SIZE = (ConfigInteger)new ConfigInteger("mapPreviewSize", 160, 16, 512).apply("minihud.config.generic");
        public static final ConfigHotkey MOVE_SHAPE_TO_PLAYER = (ConfigHotkey)new ConfigHotkey("moveShapeToPlayer", "").apply("minihud.config.generic");
        public static final ConfigBoolean OFFSET_SUBTITLE_HUD = (ConfigBoolean)new ConfigBoolean("offsetSubtitleHud", true).apply("minihud.config.generic");
        public static final ConfigHotkey OPEN_CONFIG_GUI = (ConfigHotkey)new ConfigHotkey("openConfigGui", "H,C").apply("minihud.config.generic");
        public static final ConfigBoolean REQUIRE_SNEAK = (ConfigBoolean)new ConfigBoolean("requireSneak", false).apply("minihud.config.generic");
        public static final ConfigHotkey REQUIRED_KEY = (ConfigHotkey)new ConfigHotkey("requiredKey", "", KeybindSettings.MODIFIER_INGAME_EMPTY).apply("minihud.config.generic");
        public static final ConfigInteger SERVER_NBT_REQUEST_RATE = (ConfigInteger)new ConfigInteger("serverNbtRequestRate", 2).apply("minihud.config.generic");
        public static final ConfigHotkey SET_DISTANCE_REFERENCE_POINT = (ConfigHotkey)new ConfigHotkey("setDistanceReferencePoint", "").apply("minihud.config.generic");
        public static final ConfigHotkey SHAPE_EDITOR = (ConfigHotkey)new ConfigHotkey("shapeEditor", "").apply("minihud.config.generic");
        public static final ConfigBoolean SHULKER_BOX_PREVIEW = (ConfigBoolean)new ConfigBoolean("shulkerBoxPreview", false).apply("minihud.config.generic");
        public static final ConfigBoolean SHULKER_DISPLAY_BACKGROUND_COLOR = (ConfigBoolean)new ConfigBoolean("shulkerDisplayBgColor", true).apply("minihud.config.generic");
        public static final ConfigBoolean SHULKER_DISPLAY_ENDER_CHEST = (ConfigBoolean)new ConfigBoolean("shulkerDisplayEnderChest", false).apply("minihud.config.generic");
        public static final ConfigBoolean SHULKER_DISPLAY_REQUIRE_SHIFT = (ConfigBoolean)new ConfigBoolean("shulkerDisplayRequireShift", true).apply("minihud.config.generic");
        public static final ConfigBoolean SLIME_CHUNK_TOP_TO_PLAYER = (ConfigBoolean)new ConfigBoolean("slimeChunkTopToPlayer", true).apply("minihud.config.generic");
        public static final ConfigInteger SLIME_CHUNK_OVERLAY_RADIUS = (ConfigInteger)new ConfigInteger("slimeChunkOverlayRadius", -1, -1, 40).apply("minihud.config.generic");
        public static final ConfigBoolean SLIME_CHUNK_RENDER_THROUGH = (ConfigBoolean)new ConfigBoolean("slimeChunkRenderThrough", false).apply("minihud.config.generic");
        public static final ConfigBoolean SORT_LINES_BY_LENGTH = (ConfigBoolean)new ConfigBoolean("sortLinesByLength", false).apply("minihud.config.generic");
        public static final ConfigBoolean SORT_LINES_REVERSED = (ConfigBoolean)new ConfigBoolean("sortLinesReversed", false).apply("minihud.config.generic");
        public static final ConfigBoolean SPAWN_PLAYER_OUTER_OVERLAY_ENABLED = (ConfigBoolean)new ConfigBoolean("spawnPlayerOuterOverlayEnabled", false).apply("minihud.config.generic");
        public static final ConfigBoolean SPAWN_PLAYER_REDSTONE_OVERLAY_ENABLED = (ConfigBoolean)new ConfigBoolean("spawnPlayerRedstoneOverlayEnabled", false).apply("minihud.config.generic");
        public static final ConfigInteger SPAWNABLE_COLUMNS_OVERLAY_RADIUS = (ConfigInteger)new ConfigInteger("spawnableColumnHeightsOverlayRadius", 40, 0, 128).apply("minihud.config.generic");
        public static final ConfigOptionList SPEED_UNITS = (ConfigOptionList)new ConfigOptionList("speedUnits", (IConfigOptionListEntry)SpeedUnits.MPS).apply("minihud.config.generic");
        public static final ConfigBoolean STRUCTURES_RENDER_THROUGH = (ConfigBoolean)new ConfigBoolean("structuresRenderThrough", false).apply("minihud.config.generic");
        public static final ConfigInteger TEXT_POS_X = (ConfigInteger)new ConfigInteger("textPosX", 4, 0, 8192).apply("minihud.config.generic");
        public static final ConfigInteger TEXT_POS_Y = (ConfigInteger)new ConfigInteger("textPosY", 4, 0, 8192).apply("minihud.config.generic");
        public static final ConfigInteger TIME_DAY_DIVISOR = (ConfigInteger)new ConfigInteger("timeDayDivisor", 24000, 1, Integer.MAX_VALUE).apply("minihud.config.generic");
        public static final ConfigInteger TIME_TOTAL_DIVISOR = (ConfigInteger)new ConfigInteger("timeTotalDivisor", 24000, 1, Integer.MAX_VALUE).apply("minihud.config.generic");
        public static final ConfigBoolean USE_CUSTOMIZED_COORDINATES = (ConfigBoolean)new ConfigBoolean("useCustomizedCoordinateFormat", true).apply("minihud.config.generic");
        public static final ConfigBoolean USE_FONT_SHADOW = (ConfigBoolean)new ConfigBoolean("useFontShadow", false).apply("minihud.config.generic");
        public static final ConfigBoolean USE_TEXT_BACKGROUND = (ConfigBoolean)new ConfigBoolean("useTextBackground", true).apply("minihud.config.generic");
        public static final ConfigBoolean VILLAGER_CONVERSION_TICKS = (ConfigBoolean)new ConfigBoolean("villagerConversionTicks", true).apply("minihud.config.generic");
        public static final ConfigBoolean VILLAGER_OFFER_ENCHANTMENT_BOOKS = (ConfigBoolean)new ConfigBoolean("villagerOfferEnchantmentBooks", true).apply("minihud.config.generic");
        public static final ConfigBoolean VILLAGER_OFFER_PRICE_RANGE = (ConfigBoolean)new ConfigBoolean("villagerOfferPriceRange", true).apply("minihud.config.generic");
        public static final ConfigBoolean VILLAGER_OFFER_HIGHEST_LEVEL_ONLY = (ConfigBoolean)new ConfigBoolean("villagerOfferHighestLevelOnly", false).apply("minihud.config.generic");
        public static final ConfigBoolean VILLAGER_OFFER_LOWEST_PRICE_NEARBY = (ConfigBoolean)new ConfigBoolean("villagerOfferLowestPriceNearby", false).apply("minihud.config.generic");
        public static final ConfigDouble VILLAGER_OFFER_PRICE_THRESHOLD = (ConfigDouble)new ConfigDouble("villagerOfferPriceThreshold", 1.0, 0.0, 1.0).apply("minihud.config.generic");
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)AXOLOTL_TOOLTIPS, (Object)BEE_TOOLTIPS, (Object)DISABLE_VANILLA_BEE_TOOLTIPS, (Object)BUNDLE_TOOLTIPS, (Object)BUNDLE_TOOLTIPS_FILL_LEVEL, (Object)CUSTOM_MODEL_TOOLTIPS, (Object)FOOD_TOOLTIPS, (Object)HONEY_TOOLTIPS, (Object)LODESTONE_TOOLTIPS, (Object)BIOME_OVERLAY_SINGLE_COLOR, (Object)BUNDLE_PREVIEW, (Object)BUNDLE_DISPLAY_BACKGROUND_COLOR, (Object[])new IConfigBase[]{BUNDLE_DISPLAY_REQUIRE_SHIFT, BUNDLE_DISPLAY_ROW_WIDTH, DEBUG_MESSAGES, DONT_RESET_SEED_ON_DIMENSION_CHANGE, CONDUIT_RANGE_OVERLAY_COMBINE_QUADS, CONDUIT_RANGE_OVERLAY_RENDER_OUTLINES, CONDUIT_RANGE_OVERLAY_RENDER_THROUGH, HUD_DATA_SYNC, ENTITY_DATA_SYNC, ENTITY_DATA_SYNC_BACKUP, ENTITY_DATA_SYNC_BACKUP_OPEN_TO_LAN, ENTITY_DATA_SYNC_CACHE_REFRESH, ENTITY_DATA_SYNC_CACHE_TIMEOUT, LIGHT_LEVEL_AUTO_HEIGHT, LIGHT_LEVEL_COLLISION_CHECK, LIGHT_LEVEL_COLORED_NUMBERS, LIGHT_LEVEL_NUMBER_ROTATION, LIGHT_LEVEL_RENDER_THROUGH, LIGHT_LEVEL_SKIP_BLOCK_CHECK, LIGHT_LEVEL_UNDER_WATER, MAP_PREVIEW, MAP_PREVIEW_REQUIRE_SHIFT, OFFSET_SUBTITLE_HUD, REQUIRE_SNEAK, SHULKER_BOX_PREVIEW, SHULKER_DISPLAY_BACKGROUND_COLOR, SHULKER_DISPLAY_ENDER_CHEST, SHULKER_DISPLAY_REQUIRE_SHIFT, SLIME_CHUNK_RENDER_THROUGH, SLIME_CHUNK_TOP_TO_PLAYER, SORT_LINES_BY_LENGTH, SORT_LINES_REVERSED, SPAWN_PLAYER_OUTER_OVERLAY_ENABLED, SPAWN_PLAYER_REDSTONE_OVERLAY_ENABLED, SPEED_UNITS, STRUCTURES_RENDER_THROUGH, USE_CUSTOMIZED_COORDINATES, USE_FONT_SHADOW, USE_TEXT_BACKGROUND, MAIN_RENDERING_TOGGLE, MOVE_SHAPE_TO_PLAYER, OPEN_CONFIG_GUI, REQUIRED_KEY, SERVER_NBT_REQUEST_RATE, SET_DISTANCE_REFERENCE_POINT, SHAPE_EDITOR, BLOCK_GRID_OVERLAY_MODE, LIGHT_LEVEL_MARKER_CONDITION, LIGHT_LEVEL_MARKER_MODE, LIGHT_LEVEL_NUMBER_CONDITION, LIGHT_LEVEL_NUMBER_MODE, HUD_ALIGNMENT, BIOME_OVERLAY_RANGE, BIOME_OVERLAY_RANGE_VERTICAL, BLOCK_POS_FORMAT_STRING, BLOCK_GRID_OVERLAY_RADIUS, COORDINATE_FORMAT_STRING, COPPER_AGING_MODE, DATE_FORMAT_TYPE, DATE_FORMAT_STRING, DATE_FORMAT_MINECRAFT, DURATION_FORMAT_TYPE, DURATION_FORMAT_STRING, FONT_SCALE, HUD_STATUS_EFFECTS_SHIFT, LIGHT_LEVEL_MARKER_SIZE, LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_X, LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_Y, LIGHT_LEVEL_NUMBER_OFFSET_SKY_X, LIGHT_LEVEL_NUMBER_OFFSET_SKY_Y, LIGHT_LEVEL_RANGE, LIGHT_LEVEL_THRESHOLD_DIM, LIGHT_LEVEL_THRESHOLD_SAFE, LIGHT_LEVEL_RENDER_OFFSET, MAP_PREVIEW_SIZE, SLIME_CHUNK_OVERLAY_RADIUS, SPAWNABLE_COLUMNS_OVERLAY_RADIUS, TEXT_POS_X, TEXT_POS_Y, TIME_DAY_DIVISOR, TIME_TOTAL_DIVISOR, INVENTORY_PREVIEW, INVENTORY_PREVIEW_ENABLED, INVENTORY_PREVIEW_TOGGLE_SCREEN, INVENTORY_PREVIEW_VILLAGER_BG_COLOR, VILLAGER_CONVERSION_TICKS, VILLAGER_OFFER_ENCHANTMENT_BOOKS, VILLAGER_OFFER_PRICE_RANGE, VILLAGER_OFFER_HIGHEST_LEVEL_ONLY, VILLAGER_OFFER_LOWEST_PRICE_NEARBY, VILLAGER_OFFER_PRICE_THRESHOLD});
        public static final List<IHotkey> HOTKEY_LIST = ImmutableList.of((Object)MAIN_RENDERING_TOGGLE, (Object)HUD_DATA_SYNC, (Object)HUD_STATUS_EFFECTS_SHIFT, (Object)ENTITY_DATA_SYNC, (Object)MOVE_SHAPE_TO_PLAYER, (Object)OPEN_CONFIG_GUI, (Object)REQUIRED_KEY, (Object)SET_DISTANCE_REFERENCE_POINT, (Object)SHAPE_EDITOR, (Object)INVENTORY_PREVIEW, (Object)INVENTORY_PREVIEW_TOGGLE_SCREEN);
    }
}

