/*
 * Decompiled with CFR 0.152.
 */
package carpet.api.settings;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.Validator;
import java.util.List;
import net.minecraft.class_2168;

public final class Validators {
    private Validators() {
    }

    public static class Probablity<T extends Number>
    extends Validator<T> {
        @Override
        public T validate(class_2168 source, CarpetRule<T> currentRule, T newValue, String string) {
            return ((Number)newValue).doubleValue() >= 0.0 && ((Number)newValue).doubleValue() <= 1.0 ? (T)newValue : null;
        }

        @Override
        public String description() {
            return "Must be between 0 and 1";
        }
    }

    public static class NonNegativeNumber<T extends Number>
    extends Validator<T> {
        @Override
        public T validate(class_2168 source, CarpetRule<T> currentRule, T newValue, String string) {
            return (T)(((Number)newValue).doubleValue() >= 0.0 ? newValue : null);
        }

        @Override
        public String description() {
            return "Must be a positive number or 0";
        }
    }

    public static class CommandLevel
    extends Validator<String> {
        @Deprecated(forRemoval=true)
        public static final List<String> OPTIONS = List.of("true", "false", "ops", "0", "1", "2", "3", "4");

        @Override
        public String validate(class_2168 source, CarpetRule<String> currentRule, String newValue, String userString) {
            if (!OPTIONS.contains(newValue)) {
                return null;
            }
            return newValue;
        }

        @Override
        public String description() {
            return "Can be limited to 'ops' only, true/false for everyone/no one, or a custom permission level";
        }
    }
}

