/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.config.options.ConfigTypeWrapper;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.util.JsonUtils;
import java.util.List;

public class ConfigUtils {
    public static void readConfigBase(JsonObject root, String category, List<? extends IConfigBase> options) {
        JsonObject obj = JsonUtils.getNestedObject(root, category, false);
        if (obj != null) {
            for (IConfigBase iConfigBase : options) {
                String name = iConfigBase.getName();
                if (!obj.has(name)) continue;
                iConfigBase.setValueFromJsonElement(obj.get(name));
            }
        }
    }

    public static void readHotkeys(JsonObject root, String keyHotkey, List<? extends IHotkey> hotkeys) {
        JsonObject objHotkeys = JsonUtils.getNestedObject(root, keyHotkey, false);
        if (objHotkeys != null) {
            for (IHotkey iHotkey : hotkeys) {
                String name = iHotkey.getName();
                JsonObject objKeybind = JsonUtils.getNestedObject(objHotkeys, name, false);
                if (objKeybind != null) {
                    iHotkey.getKeybind().setValueFromJsonElement((JsonElement)objKeybind);
                    continue;
                }
                if (!JsonUtils.hasString(objHotkeys, name)) continue;
                iHotkey.getKeybind().setValueFromString(JsonUtils.getString(objHotkeys, name));
            }
        }
    }

    public static void readHotkeyToggleOptions(JsonObject root, String keyHotkey, String keyBoolean, List<? extends IHotkeyTogglable> options) {
        if (JsonUtils.hasObject(root, keyHotkey)) {
            ConfigUtils.readHotkeys(root, keyHotkey, options);
        }
        if (JsonUtils.hasObject(root, keyBoolean)) {
            ConfigUtils.readConfigBase(root, keyBoolean, options);
        }
    }

    public static void writeConfigBase(JsonObject root, String category, List<? extends IConfigBase> options) {
        JsonObject obj = JsonUtils.getNestedObject(root, category, true);
        for (IConfigBase iConfigBase : options) {
            obj.add(iConfigBase.getName(), iConfigBase.getAsJsonElement());
        }
    }

    public static void writeHotkeys(JsonObject root, String category, List<? extends IHotkey> hotkeys) {
        JsonObject objHotkeys = JsonUtils.getNestedObject(root, category, true);
        for (IHotkey iHotkey : hotkeys) {
            IKeybind keybind = iHotkey.getKeybind();
            JsonObject obj = new JsonObject();
            obj.add("keys", (JsonElement)new JsonPrimitive(keybind.getStringValue()));
            if (keybind.areSettingsModified()) {
                obj.add("settings", (JsonElement)keybind.getSettings().toJson());
            }
            objHotkeys.add(iHotkey.getName(), (JsonElement)obj);
        }
    }

    public static void writeHotkeyToggleOptions(JsonObject root, String keyHotkey, String keyBoolean, List<? extends IHotkeyTogglable> options) {
        ConfigUtils.writeConfigBase(root, keyBoolean, options);
        ConfigUtils.writeHotkeys(root, keyHotkey, options);
    }

    public static List<ConfigTypeWrapper> createConfigWrapperForType(ConfigType wrappedType, List<? extends IConfigValue> toWrap) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < toWrap.size(); ++i) {
            builder.add((Object)new ConfigTypeWrapper(wrappedType, toWrap.get(i)));
        }
        return builder.build();
    }
}

