/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.google.common.collect.ImmutableSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class FileNameUtils {
    public static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    public static final ImmutableSet<Character> ILLEGAL_CHARACTERS = ImmutableSet.of((Object)Character.valueOf('/'), (Object)Character.valueOf('\n'), (Object)Character.valueOf('\r'), (Object)Character.valueOf('\t'), (Object)Character.valueOf('\u0000'), (Object)Character.valueOf('\f'), (Object[])new Character[]{Character.valueOf('`'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\\'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('|'), Character.valueOf('\"'), Character.valueOf(':')});
    public static final String REGEX_SANITIZE = "[\\\\/:*?\"<>|]|\\p{C}|\\p{M}";

    public static boolean doesFileNameContainIllegalCharacters(String filename) {
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (!ILLEGAL_CHARACTERS.contains((Object)Character.valueOf(c))) continue;
            return true;
        }
        return filename.contains("COM") || filename.contains("PRN");
    }

    public static String getDateTimeString() {
        return DATE_TIME_FORMAT.format(new Date(System.currentTimeMillis()));
    }

    public static String getFileNameExtension(String name) {
        int i = name.lastIndexOf(".");
        return i > 0 && name.length() > i + 1 ? name.substring(i + 1) : "";
    }

    public static String getFileNameWithoutExtension(String name) {
        int i = name.lastIndexOf(".");
        return i > 0 ? name.substring(0, i) : name;
    }

    public static String addExtensionIfNotExists(String name, String extension) {
        return name.endsWith(extension) ? name : name + extension;
    }

    public static String generateSimpleSafeFileName(String name) {
        boolean endsInUnderscore = ((String)name).length() >= 1 && ((String)name).charAt(((String)name).length() - 1) == '_';
        String baseName = FileNameUtils.getFileNameWithoutExtension((String)name);
        String extension = FileNameUtils.getFileNameExtension((String)name);
        baseName = baseName.toLowerCase(Locale.US).replaceAll("[^a-z0-9_.-]", "_").replaceAll("__", "_");
        name = baseName;
        if (!StringUtils.isBlank((CharSequence)extension)) {
            extension = extension.toLowerCase(Locale.US).replaceAll("[^a-z0-9_.-]", "_").replaceAll("__", "_");
            name = (String)name + "." + extension;
        }
        if (!endsInUnderscore && ((String)name).length() >= 2 && ((String)name).charAt(((String)name).length() - 1) == '_') {
            name = ((String)name).substring(0, ((String)name).length() - 1);
        }
        return name;
    }

    public static String generateSimpleUnicodeSafeFileName(String fileIn) {
        return fileIn.replaceAll(REGEX_SANITIZE, "");
    }

    public static String generateSafeFileName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (ILLEGAL_CHARACTERS.contains((Object)Character.valueOf(c))) continue;
            sb.append(c);
        }
        return sb.toString().replaceAll("COM", "").replaceAll("PRN", "");
    }
}

