/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats;

import com.mojang.brigadier.CommandDispatcher;
import io.github.thecsdev.betterstats.BetterStatsConfig;
import io.github.thecsdev.betterstats.BetterStatsProperties;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.command.StatisticsCommand;
import io.github.thecsdev.betterstats.network.BetterStatsNetwork;
import io.github.thecsdev.betterstats.server.BetterStatsServer;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.events.server.command.CommandManagerEvent;
import io.github.thecsdev.tcdcommons.command.PlayerBadgeCommand;
import net.minecraft.class_2168;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetterStats {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)BetterStats.getModID());
    private static final String ModName = "Better Statistics Screen";
    public static final String ModID = "betterstats";
    private static BetterStats Instance;
    protected final BetterStatsConfig config;

    public BetterStats() {
        if (BetterStats.isModInitialized()) {
            throw new IllegalStateException(BetterStats.getModID() + " has already been initialized.");
        }
        if (!BetterStats.isInstanceValid(this)) {
            throw new UnsupportedOperationException("Invalid " + BetterStats.getModID() + " type: " + this.getClass().getName());
        }
        Instance = this;
        LOGGER.info("Initializing '" + BetterStats.getModName() + "' as '" + this.getClass().getSimpleName() + "'.");
        this.config = new BetterStatsConfig(BetterStats.getModID());
        this.config.loadFromFileOrCrash(true);
        BetterStatsProperties.init();
        BetterStatsNetwork.init();
        CommandManagerEvent.COMMAND_REGISTRATION_CALLBACK.register((dispatcher, commandRegAccess, regEnv) -> {
            if (!this.config.registerCommands) {
                return;
            }
            StatisticsCommand.register((CommandDispatcher<class_2168>)dispatcher, commandRegAccess);
            if (TCDCommons.getInstance().getConfig().enablePlayerBadges) {
                PlayerBadgeCommand.register((CommandDispatcher)dispatcher);
            }
        });
    }

    public static BetterStats getInstance() {
        return Instance;
    }

    public BetterStatsConfig getConfig() {
        return this.config;
    }

    public static String getModName() {
        return ModName;
    }

    public static String getModID() {
        return ModID;
    }

    public static boolean isModInitialized() {
        return BetterStats.isInstanceValid(Instance);
    }

    private static boolean isInstanceValid(BetterStats instance) {
        return BetterStats.isServer(instance) || BetterStats.isClient(instance);
    }

    public static boolean isServer() {
        return BetterStats.isServer(Instance);
    }

    public static boolean isClient() {
        return BetterStats.isClient(Instance);
    }

    private static boolean isServer(BetterStats arg0) {
        return arg0 instanceof BetterStatsServer;
    }

    private static boolean isClient(BetterStats arg0) {
        return arg0 instanceof BetterStatsClient;
    }
}

